% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Faddeeva_w}
\alias{Dawson}
\alias{Faddeeva_w}
\alias{erf}
\alias{erfc}
\alias{erfcx}
\alias{erfi}
\title{Faddeeva family of error functions of the complex variable}
\usage{
Faddeeva_w(z, relerr = 0)

erfcx(z, relerr = 0)

erf(z, relerr = 0)

erfi(z, relerr = 0)

erfc(z, relerr = 0)

Dawson(z, relerr = 0)
}
\arguments{
\item{z}{complex vector}

\item{relerr}{double, requested error}
}
\value{
complex vector
}
\description{
the Faddeeva function

the scaled complementary error function

the error function of complex arguments

the imaginary error function

the complementary error function

the Dawson function
}
\section{Functions}{
\itemize{
\item \code{Faddeeva_w}: compute w(z) = exp(-z^2) erfc(-iz)

\item \code{erfcx}: compute erfcx(z) = exp(z^2) erfc(z)

\item \code{erf}: compute erf(z)

\item \code{erfi}: compute erfi(z) = -i erf(iz)

\item \code{erfc}: compute erfc(z) = 1 - erf(z)

\item \code{Dawson}: compute Dawson(z) = sqrt(pi)/2  *  exp(-z^2) * erfi(z)
}}
\examples{
Faddeeva_w(1:10 + 1i)
erfcx(1:10 + 1i)
erf(1:10 + 1i)
erfi(1:10 + 1i)
erfc(1:10 + 1i)
Dawson(1:10 + 1i)
}

