% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canon.R
\name{Rd_canonize}
\alias{Rd_canonize}
\alias{Rd_canonize_text}
\alias{Rd_canonize_code}
\title{Rd Canonical Form}
\usage{
Rd_canonize(rd, ..., .check = TRUE)

Rd_canonize_text(rd, .check = TRUE, ...)

Rd_canonize_code(rd, .check = TRUE, ...)
}
\arguments{
\item{rd}{the Rd container object to put in canonical form.}

\item{...}{Arguments passed on to \code{is_valid_Rd_object}
\describe{
  \item{x}{object to test}
  \item{strict}{if the class must be set. A value of NA indicates that the
first level need not be classed but all subsequent must be.}
  \item{tags}{the type of tag(s) allowed in the \code{Rd_tag} attribute.}
  \item{deep}{should contained elements also be checked for validity?}
}}

\item{.check}{Perform input checks?}
}
\description{
Canonical form is simply described as that which would come out from reading
an Rd file via, \code{\link[tools:parse_Rd]{tools::parse_Rd()}}.
}
\details{
\strong{Canonical Rd Text has:}
\itemize{
\item One line per element, with \code{attr(., 'Rd_tag')=='TEXT'}
\item The indents are merged with content if the first content is text.
\item Newlines are contained with the content provided the content is 'TEXT',
but the newline must be the last character in the string and cannot appear anywhere else.
\item Comments are a separate class and do not include the newline.
}

\strong{Canonical R code follows the following rules:}
\itemize{
\item One element per line of code.
\item newline is included at the end of the line string,
not as a separate element.
\item if there are multiple lines they are bound together in an Rd or Rd_tag list.
}
}
\section{Functions}{
\itemize{
\item \code{Rd_canonize_text}: Put text in canonical form.

\item \code{Rd_canonize_code}: Put R code in canonical form.
}}

\examples{
## Rd_c does not guarantee canonical code.
x <- Rd_c(Rd('Testing'), Rd('\\n'))
str(x)
str(Rd_canonize(x))
}
