% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concepts.R
\name{acronyms}
\alias{acronyms}
\title{Extract acronyms stated in the description of SNOMED CT concepts}
\usage{
acronyms(conceptIds, SNOMED = getSNOMED())
}
\arguments{
\item{conceptIds}{character or integer64 vector}

\item{SNOMED}{environment containing SNOMED dictionary. Defaults
to an object named 'SNOMED' in the global environment}
}
\value{
a data.table with the following columns: id, conceptId,
  type = 'Acronym', term = acronym
}
\description{
Returns acronyms, if any, expressed within SNOMED CT descriptions
in the form 'ABCD - Another Bland Cardiovascular Disease'.
}
\examples{
SNOMED <- sampleSNOMED()
acronyms('Heart failure')

# Get all synonyms and acronyms
rva <- SNOMEDconcept('Right ventricular abnormality')
rbind(description(rva, include_synonyms = TRUE), acronyms(rva))
}
