% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_PLS.R
\name{do.pls}
\alias{do.pls}
\title{Partial Least Squares}
\usage{
do.pls(data1, data2, ndim = 2)
}
\arguments{
\item{data1}{an \code{(n-by-N)} data matrix whose rows are observations}

\item{data2}{an \code{(n-by-M)} data matrix whose rows are observations}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named list containing
\describe{
\item{Y1}{an \code{(n-by-ndim)} matrix of projected observations from \code{data1}.}
\item{Y2}{an \code{(n-by-ndim)} matrix of projected observations from \code{data2}.}
\item{projection1}{a \code{(N-by-ndim)} whose columns are loadings for \code{data1}.}
\item{projection2}{a \code{(M-by-ndim)} whose columns are loadings for \code{data2}.}
\item{trfinfo1}{a list containing information for out-of-sample prediction for \code{data1}.}
\item{trfinfo2}{a list containing information for out-of-sample prediction for \code{data2}.}
\item{eigvals}{a vector of eigenvalues for iterative decomposition.}
}
}
\description{
Given two data sets, Partial Least Squares (PLS) aims at maximizing cross-covariance of latent variables for each data matrix,
therefore it can be considered as supervised methods. As we have two input matrices, \code{do.pls} generates two sets of
outputs. Though it is widely used for regression problem, we used it in dimension reduction setting. For
algorithm aspects, we used recursive gram-schmidt orthogonalization in conjunction with extracting projection vectors under
eigen-decomposition formulation, as the problem dimension matters only up to original dimensionality.
For more details, see \href{https://en.wikipedia.org/wiki/Partial_least_squares_regression}{Wikipedia entry} on PLS.
}
\examples{
## generate 2 normal data matrices
mat1 = matrix(rnorm(100*12),nrow=100)+10 # 12-dim normal
mat2 = matrix(rnorm(100*6), nrow=100)-10 # 6-dim normal

## project onto 2 dimensional space for each data
output = do.pls(mat1, mat2, ndim=2)

## visualize
par(mfrow=c(1,2))
plot(output$Y1[,1], output$Y1[,2], main="proj(mat1)")
plot(output$Y2[,1], output$Y2[,2], main="proj(mat2)")

}
\references{
\insertRef{wold_path_1975}{Rdimtools}

\insertRef{rosipal_overview_2006}{Rdimtools}
}
\seealso{
\code{\link{do.cca}}
}
\author{
Kisung You
}
