% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_BPCA.R
\name{do.bpca}
\alias{do.bpca}
\title{Bayesian Principal Component Analysis}
\usage{
do.bpca(X, ndim = 2, preprocess = c("center", "decorrelate", "whiten"),
  reltol = 1e-04, maxiter = 123)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an option for preprocessing the data. This supports three methods,
``center'' (default),``decorrelate'', or ``whiten''. See also \code{\link{aux.preprocess}}
for more details.}

\item{reltol}{stopping criterion for iterative update for EM algorithm.}

\item{maxiter}{maximum number of iterations allowed for EM algorithm.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)}  whose columns are principal components.}
\item{mp.itercount}{the number of iterations taken for EM algorithm to converge.}
\item{mp.sigma2}{estimated \eqn{\sigma^2} value via EM algorithm.}
\item{mp.alpha}{length-\code{ndim-1} vector of relative weight for each base in \code{mp.W}.}
\item{mp.W}{an \eqn{(ndim\times ndim-1)} matrix from EM update.}
}
}
\description{
Bayesian PCA (BPCA) is a further variant of PCA in that it imposes prior and encodes
basis selection mechanism. Even though the model is fully Bayesian, \code{do.bpca}
faithfully follows the original paper by Bishop in that it only returns the mode value
of posterior as an estimate, in conjunction with ARD-motivated prior as well as
consideration of variance to be estimated. Unlike PPCA, it uses full basis and returns
relative weight for each base in that the smaller \eqn{\alpha} value is, the more likely
corresponding column vector of \code{mp.W} to be selected as potential basis.
}
\examples{
\dontrun{
## generate data of 2 multivariate normals
x1 = matrix(rnorm(100),nrow=10)-10
x2 = matrix(rnorm(100),nrow=10)+10
X  = rbind(x1,x2)

## Compare PCA and BPCA
out1  <- do.pca(X, ndim=2, preprocess="center")
out2  <- do.bpca(X, ndim=2, preprocess="center")

## Visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="PCA")
plot(out2$Y[,1], out2$Y[,2], main="BPPCA")
}

}
\references{
\insertRef{bishop_bayesian_1999}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}, \code{\link{do.ppca}}
}
\author{
Kisung You
}
