% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KPCA.R
\name{do.kpca}
\alias{do.kpca}
\title{Kernel Principal Component Analysis}
\usage{
do.kpca(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  kernel = c("gaussian", 1)
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{kernel}{a vector containing name of a kernel and corresponding parameters. See also \code{\link{aux.kernelcov}} for complete description of Kernel Trick.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{vars}{variances of projected data / eigenvalues from kernelized covariance matrix.}
}
}
\description{
Kernel principal component analysis (KPCA/Kernel PCA) is a nonlinear extension of classical
PCA using techniques called \href{https://en.wikipedia.org/wiki/Kernel_method}{kernel trick},
a common method of introducing nonlinearity by transforming, usually, covariance structure or
other gram-type estimate to make it flexible in Reproducing Kernel Hilbert Space.
}
\examples{
\donttest{
## generate ribbon-shaped data
X = aux.gensamples(dname="ribbon",n=123)

## 1. standard KPCA with gaussian kernel
output1 <- do.kpca(X,ndim=2)

## 2. gaussian kernel with large bandwidth
output2 <- do.kpca(X,ndim=2,kernel=c("gaussian",5))

## 3. use laplacian kernel
output3 <- do.kpca(X,ndim=2,kernel=c("laplacian",1))

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="Gaussian kernel")
plot(output2$Y, main="Gaussian kernel with sigma=5")
plot(output3$Y, main="Laplacian kernel")
par(opar)
}

}
\references{
\insertRef{scholkopf_kernel_1997}{Rdimtools}
}
\seealso{
\code{\link{aux.kernelcov}}
}
\author{
Kisung You
}
