% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_UGFS.R
\name{do.ugfs}
\alias{do.ugfs}
\title{Unsupervised Graph-based Feature Selection}
\usage{
do.ugfs(
  X,
  ndim = 2,
  nbdk = 5,
  varthr = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{nbdk}{the size of neighborhood for local variance computation.}

\item{varthr}{threshold value for affinity graph construction. If too small so that the graph of variables is not constructed, it returns an error.}

\item{preprocess}{an additional option for preprocessing the data. Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{prscore}{a length-\eqn{p} vector of score computed from PageRank algorithm. Indices with largest values are selected.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
UGFS is an unsupervised feature selection method with two parameters \code{nbdk} and \code{varthr} that it constructs
an affinity graph using local variance computation and scores variables based on PageRank algorithm.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
iris.dat <- as.matrix(iris[,1:4])
iris.lab <- as.factor(iris[,5])

## try multiple thresholding values
out1 = do.ugfs(iris.dat, nbdk=10, varthr=0.5)
out2 = do.ugfs(iris.dat, nbdk=10, varthr=5.0)
out3 = do.ugfs(iris.dat, nbdk=10, varthr=9.5)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=iris.lab, main="bandwidth=0.1")
plot(out2$Y, pch=19, col=iris.lab, main="bandwidth=1")
plot(out3$Y, pch=19, col=iris.lab, main="bandwidth=10")
par(opar)
}

}
\references{
\insertRef{henni_unsupervised_2018}{Rdimtools}
}
\author{
Kisung You
}
\concept{feature_methods}
