% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_linear_LMDS.R
\name{do.lmds}
\alias{do.lmds}
\title{Landmark Multidimensional Scaling}
\usage{
do.lmds(X, ndim = 2, npoints = max(nrow(X)/5, ndim + 1))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{npoints}{the number of landmark points to be drawn.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Landmark MDS is a variant of Classical Multidimensional Scaling in that
it first finds a low-dimensional embedding using a small portion of given dataset
and graft the others in a manner to preserve as much pairwise distance from
all the other data points to landmark points as possible.
}
\examples{
\donttest{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## use 10\% and 25\% of the data and compare with full MDS
output1 <- do.lmds(X, ndim=2, npoints=round(nrow(X)*0.10))
output2 <- do.lmds(X, ndim=2, npoints=round(nrow(X)*0.25))
output3 <- do.mds(X, ndim=2)

## vsualization
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, pch=19, col=lab, main="10\% random points")
plot(output2$Y, pch=19, col=lab, main="25\% random points")
plot(output3$Y, pch=19, col=lab, main="original MDS")
par(opar)
}

}
\references{
\insertRef{silva_global_2002}{Rdimtools}

\insertRef{lee_landmark_2009}{Rdimtools}
}
\seealso{
\code{\link{do.mds}}
}
\author{
Kisung You
}
\concept{linear_methods}
