% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_feature_FOSMOD.R
\name{do.fosmod}
\alias{do.fosmod}
\title{Forward Orthogonal Search by Maximizing the Overall Dependency}
\usage{
do.fosmod(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{...}{extra parameters including \describe{
\item{preprocess}{an additional option for preprocessing the data.
See also \code{\link{aux.preprocess}} for more details (default: \code{"center"}).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
The FOS-MOD algorithm \insertCite{wei_2007_FeatureSubsetSelection}{Rdimtools}
is an unsupervised algorithm that selects a desired number of features in
a forward manner by ranking the features using the squared correlation
coefficient and sequential orthogonalization.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
set.seed(100)
subid    <- sample(1:150, 50)
iris.dat <- as.matrix(iris[subid,1:4])
iris.lab <- as.factor(iris[subid,5])

## compare with other methods
out1 = do.fosmod(iris.dat)
out2 = do.lscore(iris.dat)
out3 = do.fscore(iris.dat, iris.lab)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=iris.lab, main="FOS-MOD")
plot(out2$Y, pch=19, col=iris.lab, main="Laplacian Score")
plot(out3$Y, pch=19, col=iris.lab, main="Fisher Score")
par(opar)
}

}
\references{
\insertAllCited{}
}
\concept{feature_methods}
