% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvbasismfdClass.R
\name{mvbasismfd}
\alias{mvbasismfd}
\alias{Mvbasismfd}
\alias{[.mvbasismfd}
\title{Define a Set of Multivariate Multidimensional Functional Basis}
\usage{
Mvbasismfd(basis)

Mvbasismfd(basis)

\method{[}{mvbasismfd}(mvbasismfd_obj, i = "index")
}
\arguments{
\item{basis}{A list of basisfd objects}

\item{mvbasismfd_obj}{An 'mvmfd' object}

\item{i}{An index or indices specifying the subsets to extract for the first dimension}
}
\value{
An `mvbasismfd` object containing the specified subsets
}
\description{
The `mvbasismfd` a set of  multivariate multidimensional basis functions.
This class utilizes basis objects `basismfd`.

Constructor for `mvbasismfd` objects (same as `Mvbasismfd`)
}
\seealso{
\code{\link{mvmfd}}, \code{\link{basismfd}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nvar}}{number of variables}

\item{\code{basis}}{A list of `mvbasisfd` objects}

\item{\code{dimSupp}}{A sequence of positive integers specifying support domain of the `mvbasismfd` object.}

\item{\code{nbasis}}{A list of integers specifying the number of basis functions}

\item{\code{supp}}{A list of matrices specifying the support of basis functions}

\item{\code{gram}}{The Gram matrix.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mvbasismfd-new}{\code{mvbasismfd$new()}}
\item \href{#method-mvbasismfd-eval}{\code{mvbasismfd$eval()}}
\item \href{#method-mvbasismfd-clone}{\code{mvbasismfd$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mvbasismfd-new"></a>}}
\if{latex}{\out{\hypertarget{method-mvbasismfd-new}{}}}
\subsection{Method \code{new()}}{
Constructor for `mvbasismfd` objects (same as Mvbasismfd(...) )
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mvbasismfd$new(basis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{basis}}{A list of `basismfd` objects}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mvbasismfd-eval"></a>}}
\if{latex}{\out{\hypertarget{method-mvbasismfd-eval}{}}}
\subsection{Method \code{eval()}}{
Evaluate the `mvbasismfd` object at given argument values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mvbasismfd$eval(evalarg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{evalarg}}{A list of numeric vectors of argument values at which the `mvbasismfd` is to be evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of evaluated values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mvbasismfd-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mvbasismfd-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mvbasismfd$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
