% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_network.R
\name{user_network}
\alias{user_network}
\title{User relationship network}
\usage{
user_network(thread_df, include_author = TRUE, agg = FALSE)
}
\arguments{
\item{thread_df}{a data frame with columns structure, user, author -- designed for the output of the reddit_content() or get_reddit() functions}

\item{include_author}{a TRUE/FALSE indicator for whether or not the author should be considered in the resulting network, if TRUE, comments at the top of the tree will be treated as relies to the original posts, otherwise these comments will be disregarded}

\item{agg}{a TRUE/FALSE indicator that allows you to aggregate results, if FALSE, the results will remain disaggregated}
}
\value{
a list with df (effectively an edge list without IDs), node_df (node list), edge_df (edge list), igrpah (igraph object), plot (plot object)
}
\description{
User relationship network
}
\examples{
\dontrun{
# load libraries
library(dplyr)
library(RedditExtractoR)
target_urls <- reddit_urls(search_terms="cats", subreddit="Art", cn_threshold=50)
target_df <- target_urls \%>\% 
filter(num_comments==min(target_urls$num_comments)) \%$\% 
URL \%>\% reddit_content # get the contents of a small thread
network_list <- target_df \%>\% user_network(include_author=FALSE, agg=TRUE) # extract the network
network_list$plot # explore the plot
str(network_list$df) # check out the contents
}
}
