% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head.BibEntry.R
\name{head.BibEntry}
\alias{head.BibEntry}
\alias{tail.BibEntry}
\title{Return the first or last part of a BibEntry object}
\usage{
\method{head}{BibEntry}(x, n = 6L, suppress.messages = TRUE, ...)

\method{tail}{BibEntry}(x, n = 6L, suppress.messages = TRUE, ...)
}
\arguments{
\item{x}{an object of class BibEntry.}

\item{n}{a single integer. If positive, size for the resulting object: number of elements for a vector 
(including lists), rows for a matrix or data frame or lines for a function. If negative, all but the 
n last/first number of elements of x.}

\item{suppress.messages}{boolean; should the head/tail entries be printed via \code{\link{message}}?}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
an object of class BibEntry.
}
\description{
Prints the first or last entries of a BibEntry object (via \code{\link{message}}) and returns them \emph{invisibly} 
  (via \code{\link{invisible}}).
}
\details{
If \code{suppress.messages} is \code{FALSE}, the head/tail entries are output to the console along
  with some additional formatting for the \sQuote{bibtype} and \sQuote{key}, in addition to
invisibly returning the entries.
}
\examples{
file <- system.file("Bib", "biblatexExamples.bib", package = "RefManageR")
BibOptions(check.entries = FALSE)
bib <- ReadBib(file)
tail(bib, 2, suppress.messages = FALSE)
bib <- head(bib, 1, suppress.messages = TRUE)
}
