% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective_support.R
\name{objective_support}
\alias{objective_support}
\title{Internal function to minimize to compute the function sigma for the projections of the identified set}
\usage{
objective_support(
  x,
  dir_nb,
  sam0,
  eps1,
  Xc_xb,
  Xncb,
  Xc_yb,
  Yb,
  values,
  grid,
  weights_x,
  weights_y,
  constraint,
  c_sign,
  nc_sign,
  refs0,
  meth = "adapt",
  T_xy,
  bc = FALSE,
  version = "first",
  R2bound = NULL,
  values_sel = NULL,
  ties = FALSE
)
}
\arguments{
\item{x}{value at which the function is evaluated.}

\item{dir_nb}{the index of the considered direction.}

\item{sam0}{the set of directions e where to compute the support function}

\item{eps1}{the matrix of directions q, along the canonical axis, and the selected epsilon(q)}

\item{Xc_xb}{the possibly bootstraped/subsampled common regressor on the dataset  (Xnc,Xc). Default is NULL.}

\item{Xncb}{the possibly bootstraped/subsampled noncommon regressor on the dataset (Xnc,Xc). No default.}

\item{Xc_yb}{the possibly bootstraped/subsampled common regressor on the dataset  (Y,Xc). Default is NULL.}

\item{Yb}{the possibly bootstraped/subsampled outcome variable  on the dataset  (Y,Xc). No default.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to kp.}

\item{weights_x}{the bootstrap or sampling weights for the dataset (Xnc,Xc).}

\item{weights_y}{the bootstrap or sampling weights for the dataset (Y,Xc).}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.}

\item{c_sign}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nc_sign}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{meth}{the method for the choice of epsilon, either "adapt", i.e. adapted to the direction or "min" the minimum over the directions. Default is "adapt".}

\item{T_xy}{the apparent sample size the taking into account the difference in the two datasets.}

\item{bc}{if TRUE compute also the bounds on betac. Default is FALSE.}

\item{version}{version of the computation of the ratio, "first" is a degraded version but fast; "second" is a correct version but slower. Default is "second".}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{values_sel}{the selected values of Xc for the conditioning. Default is NULL.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}
}
\value{
the value the support function
}
\description{
Internal function to minimize to compute the function sigma for the projections of the identified set
}
