% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regCombin_profile.R
\name{regCombin_profile}
\alias{regCombin_profile}
\title{Computing the DGM bounds for different values of epsilon, proportional to the data-driven  selected one}
\usage{
regCombin_profile(
  Ldata,
  Rdata,
  out_var,
  nc_var,
  c_var = NULL,
  constraint = NULL,
  nc_sign = NULL,
  c_sign = NULL,
  weights_x = NULL,
  weights_y = NULL,
  nbCores = 1,
  methods = c("DGM"),
  grid = 10,
  alpha = 0.05,
  eps_default = 0.5,
  R2bound = NULL,
  projections = FALSE,
  unchanged = FALSE,
  ties = FALSE,
  multipliers = c(0.25, 0.5, 1, 1.5, 2)
)
}
\arguments{
\item{Ldata}{dataset containing (Y,Xc) where Y is the outcome, Xc are potential common regressors.}

\item{Rdata}{dataset containing (Xnc,Xc) where Xnc are the non commonly observed regressors, Xc are potential common regressors.}

\item{out_var}{label of the outcome variable Y.}

\item{nc_var}{label of the non commonly observed regressors Xnc.}

\item{c_var}{label of the commonly observed regressors Xc.}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.}

\item{nc_sign}{if sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{c_sign}{if sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{weights_x}{the sampling weights for the dataset (Xnc,Xc). Default is NULL.}

\item{weights_y}{the sampling weights for the dataset (Y,Xc). Default is NULL.}

\item{nbCores}{number of cores for the parallel computation. Default is 1.}

\item{methods}{method used for the bounds: "DGM" (Default) and/or "Variance".}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to eps_default.}

\item{alpha}{the level of the confidence intervals. Default is 0.05.}

\item{eps_default}{If grid =NULL, then epsilon is taken equal to eps_default.}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{projections}{if FALSE compute the identified set along some directions or the confidence regions. Default is FALSE}

\item{unchanged}{Boolean indicating if the categories based on Xc must be kept unchanged (TRUE). Otherwise (FALSE), a thresholding approach is taken imposing that each value appears more than 10 times in both datasets and 0.01 per cent is the pooled one. Default is FALSE.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}

\item{multipliers}{different multipliers of our selected epsilon to compute the bounds. Default is 0.25,0.5,1,1.5,2.}
}
\value{
a list containing, in order:
- details: a list with all the detailled results of the estimation for the different multipliers. see "regCombin".

- Profile_point : a matrix with the profile of the bounds without constraints for different values of the multiplier.

- Profile_point_sign : a matrix with the profile of the bounds with constraints for different values of the multiplier.
}
\description{
Computing the DGM bounds for different values of epsilon, proportional to the data-driven  selected one
}
\examples{
### Simulating according to this DGP
n=200
Xnc_x = rnorm(n,0,1.5)
Xnc_y = rnorm(n,0,1.5)
epsilon = rnorm(n,0,1)

## true value
beta0 =1
Y = Xnc_y*beta0 + epsilon
out_var = "Y"
nc_var = "Xnc"

# create the datasets
Ldata<- as.data.frame(Y)
colnames(Ldata) <- c(out_var)
Rdata <- as.data.frame(Xnc_x)
colnames(Rdata) <- c(nc_var)


############# Estimation #############
profile = regCombin_profile(Ldata,Rdata,out_var,nc_var, multipliers = seq(0.1,3,length.out=3))

}
