% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_epsilon_test.R
\name{select_epsilon_test}
\alias{select_epsilon_test}
\title{Function for the data-driven selection of the epsilon tuning parameter,  adapted to the point identification test.}
\usage{
select_epsilon_test(
  sam1,
  eps_default,
  Xc_x,
  Xnc,
  Xc_y,
  Y,
  values,
  dimXc,
  dimXnc,
  nb_pts,
  lim,
  weights_x,
  weights_y,
  refs0,
  grid = 30,
  constraint = NULL,
  c_sign = NULL,
  nc_sign = NULL,
  meth = "adapt",
  nbCores = 1,
  version_sel = "first",
  alpha = 0.05,
  ties = FALSE
)
}
\arguments{
\item{sam1}{the matrix containing the directions q on which to compute the selected rule for epsilon(q)}

\item{eps_default}{If grid =NULL, then epsilon is taken equal to eps_default.}

\item{Xc_x}{the common regressor on the dataset  (Xnc,Xc). Default is NULL.}

\item{Xnc}{the noncommon regressor on the dataset  (Xnc,Xc). No default.}

\item{Xc_y}{the common regressor on the dataset  (Y,Xc). Default is NULL.}

\item{Y}{the outcome variable. No default.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{dimXc}{the dimension of the common regressors Xc.}

\item{dimXnc}{the dimension of the noncommon regressors Xnc.}

\item{nb_pts}{the constant C in DGM for the epsilon_0, the lower bound on the grid for epsilon, taken equal to nb_pts*ln(n)/n. Default is 1 without regressors Xc, 3 with Xc.}

\item{lim}{the lim number of observations under which we do no compute the conditional variance.}

\item{weights_x}{the sampling weights for the dataset (Xnc,Xc).}

\item{weights_y}{the sampling weights for the dataset (Y,Xc).}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to eps_default.}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.}

\item{c_sign}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nc_sign}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{meth}{the method for the choice of epsilon, either "adapt", i.e. adapted to the direction or "min" the minimum over the directions. Default is "adapt".}

\item{nbCores}{number of cores for the parallel computation. Default is 1.}

\item{version_sel}{version of the selection of the epsilon, "first" indicates no weights, no ties, same sizes of the two datasets; "second" otherwise. Default is "second".}

\item{alpha}{the level for the confidence regions. Default is 0.05.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}
}
\value{
a matrix containing the values of the selected epsilon(q) for q directions in sam1.
}
\description{
Function for the data-driven selection of the epsilon tuning parameter,  adapted to the point identification test.
}
