% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detransform.R
\name{detransform}
\alias{detransform}
\title{Detransform Centered/Scaled Data}
\usage{
detransform(x_data, ...)
}
\arguments{
\item{x_data}{Model matrix that has been centered and/or scaled.}

\item{...}{Additional arguments specifying centering/scaling attributes.}
}
\value{
Returns de-centered and de-scaled model matrix.
}
\description{
This function back transforms centered/scaled data.
}
\details{
The following additional arguments can be passed:
\itemize{
\item \code{attr_center} : Centering attributes.
\itemize{
\item If none specified, \code{attr(x_data,'scaled:center')} is utilized.
}
\item \code{attr_scale} : Scaling attributes.
\itemize{
\item If none specified, \code{attr(x_data,'scaled:scale')} is utilized.
}
}
}
\examples{
# Set seed for reproducibility
set.seed(1964)
# Generate a 10x10 matrix with random numbers
original_data <- matrix(rnorm(100), nrow = 10)
# Scale and center the data
scaled_centered_data <- scale(original_data, center = TRUE,
scale = TRUE)
# Transform the scaled/centered data back to its original form
original_data_recovered <- detransform(scaled_centered_data)
# Compare the original data and the recovered data
all.equal(original_data,original_data_recovered)
}
\seealso{
\itemize{
\item \code{\link[base]{scale}} for centering and scaling.
\item \code{\link[base]{all.equal}} for testing "near equality".
}
}
