% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_structuredSCA.R
\name{cv_structuredSCA}
\alias{cv_structuredSCA}
\title{A K-fold cross-validation procedure when common/distinctive processes are
known, with a Lasso penalty.}
\usage{
cv_structuredSCA(DATA, Jk, R, Target, Position, MaxIter, NRSTARTS,
  LassoSequence, nfolds)
}
\arguments{
\item{DATA}{The concatenated data block, with rows representing subjects.}

\item{Jk}{A vector. Each element of this vector is the number of columns of a
data block.}

\item{R}{The number of components (R>=2).}

\item{Target}{A matrix containing 0's and 1's. Its number of columns equals to R, and its number of rows equals to the number of blocks to be integrated. Thus, if the element in}

\item{Position}{Indicate on which component(s) the Lasso Penalty is imposed. If unspecified, the algorithm assume that the 
Lasso penalty is imposed on the common component(s) only. If there is no common component, then Lasso penalty is applied to all components.}

\item{MaxIter}{Maximum number of iterations for this algorithm. The default
value is 400.}

\item{NRSTARTS}{The number of multistarts for this algorithm. The default
value is 5.}

\item{LassoSequence}{The range of lasso tuning parameters. The default value
is a sequence of 50 numbers from 0.00000001 to the smallest Lasso tuning parameter
that can make the entire common component(s) to be zeros. Note that by default the 50 numbers are equally spaced on the log scale.}

\item{nfolds}{Number of folds. If missing, then 10 fold cross-validation will
be performed.}
}
\value{
\item{MSPE}{A vector of mean squared prediction error (MSPE) for the sequence of Lasso tuning parameter values.}
\item{MSPE1SE}{The lowest MSPE + 1SE.}
\item{Standard_Error}{Standard errors.}
\item{LassoSequence}{The sequence of Lasso tuning parameters used in cross-validation.}
\item{plot}{A plot of mean square errors +/- 1 standard error against Lasso tuning parameters. The plot is plotted against a log scale of lambda if \code{LassoSequence} is not defined by users. }
\item{LassoRegion}{A region where the suitable lambda can be found, according to the "1 SE rule". }
\item{RecommendedLasso}{A Lasso tuning parameter that leads to a model with PRESS closest to the lowest PRESS + 1SE.}
\item{P_hat}{Estimated component loading matrix, given the recommended tuning parameter.}
\item{T_hat}{Estimated component score matrix, given the recommended tuning parameter.}
\item{plotlog}{An index number for function \code{plot()}, which is not useful for users.}
}
\description{
\code{cv_structuredSCA} helps to find a range of lasso tuning parameters for the
common component so as to generate sparse common component.
}
\details{
This function searches through a range of lasso tuning parameters for the common
component, while keeping distinctive components fixed (- that is, the zeros in
the distinctive components are fixed). This function may be of help if a user
wants to obtain some sparseness in the common component.
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5)
DATA <- cbind(DATA1, DATA2)
Jk <- c(10, 20) #DATA1 has 10 columns, DATA2 20.
R <- 4 
Target <- matrix(c(1,1,1,0,1,0,0,1), 2, 4) 
cv_structuredSCA(DATA, Jk, R, Target, MaxIter = 100, NRSTARTS = 40, 
                LassoSequence = seq(from= 0.002, to=0.1, 
                length.out = 10))
}
}
\references{
Witten, D.M., Tibshirani, R., & Hastie, T. (2009), A penalized matrix decomposition, with applications to sparse principal components and canonical correlation analysis. \emph{Biostatistics}, \emph{10}(3), 515-534.

Gu, Z., & Van Deun, K. (2016). A variable selection method for simultaneous component based data integration. \emph{Chemometrics and Intelligent Laboratory Systems}, \emph{158}, 187-199.
}
