\name{henv}
\alias{henv}
\title{Fit the heteroscedastic envelope model}
\description{
 Fit the heteroscedastic envelope model with dimension u. 
}
\usage{
henv(X, Y, u, asy = TRUE, fit = TRUE, init = NULL)
}

\arguments{
  \item{X}{
  A group indicator vector of length \eqn{n}, where \eqn{n} 
  denotes the number of observations.
  }
  \item{Y}{
  Multivariate responses. An n by r matrix, r is the number of responses and n is number of observations. The responses must be continuous variables.
  }
  \item{u}{
  Dimension of the heteroscedastic envelope. An integer between 0 and r.
  }
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{fit}{Flag for computing the fitted response.  The default is \code{TRUE}.}
  \item{init}{The user-specified value of Gamma for the heteroscedastic envelope subspace. An r by u matrix. The default is the one generated by function henvMU.}
}
\details{
 This function fits the heteroscedastic envelope model to the responses, \deqn{
 Y_{(i)j} = \mu + \Gamma\eta_{(i)} +\varepsilon_{(i)j}, \Sigma_{(i)}=\Gamma\Omega_{(i)}\Gamma'+\Gamma_{0}\Omega_{0}\Gamma'_{0}
 }
 for i = 1, ..., p, using the maximum likelihood estimation.  When the dimension of the heteroscedastic envelope is between 1 and r-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is r, then the envelope model degenerates to the standard multivariate linear regression for comparing group means.  When the dimension is 0, it means there is no any group effect, and the fitting is different. 
}

\value{The output is a list that contains the following components:
  \item{beta}{
  The heteroscedastic envelope estimator of the group main effect. An 
  r by p matix, the ith column of the matrix contains the main effect 
  for the ith group.
  }
  \item{Sigma}{
  A list of the heteroscedastic envelope estimator of the error 
  covariance matrix. \code{Sigma}[[i]] contains the estimated 
  covariance matrix for the ith group.
  }	
  \item{Gamma}{
  An orthonormal basis of the heteroscedastic envelope subspace.
  }
  \item{Gamma0}{
  An orthonormal basis of the complement of the heteroscedastic envelope subspace.
  }
  \item{eta}{
  A list of the coordinates of beta with respect to Gamma. \code{eta}
  [[i]] indicates the coordinates of the main effect of the ith group 
  with respect to Gamma.
  }
  \item{Omega}{
  A list of the coordinates of Sigma with respect to Gamma. 
  \code{Omega}[[i]] indicates the coordinates of the covariance matrix 
  of the ith group with respect to Gamma.
  }
  \item{Omega0}{
  The coordinates of Sigma with respect to Gamma0.
  }
  \item{mu}{
  The heteroscedastic envelope estimator of the grand mean. A r by 1 
  matrix.
  }
  \item{mug}{
  A list of the heteroscedastic envelope estimator of the group mean. 
  An r by p matix, the ith column of the matrix contains the mean for 
  the ith group.
  }
  \item{loglik}{
  The maximized log likelihood function.
  }
  \item{covMatrix}{
  The asymptotic covariance of (mu, vec(beta)')'. An r(p + 1) by r(p + 
  1) matrix. The covariance matrix returned are asymptotic.  For the 
  actual standard errors, multiply by 1 / n. 
  }
  \item{asySE}{
  The asymptotic standard error for elements in beta under the 
  heteroscedastic envelope model. An r by p matrix. The standard 
  errors returned are asymptotic, for actual standard errors, multiply 
  by 1 / sqrt(n). 
  }
  \item{ratio}{
  The asymptotic standard error ratio of the standard multivariate 
  linear regression for comparing group means over the heteroscedastic 
  envelope estimator, for each element in beta. An r by p matrix.
  }
  \item{groupInd}{
  A matrix containing the unique values of group indicators. The 
  matrix has p rows.	
  }
  \item{n}{
  The number of observations in the data.
  }
  \item{ng}{
  The number of observations in each group.
  }
  \item{Yfit}{
  Fitted responses.
  }
}

\references{
  Su, Z. and Cook, R. D. (2013)  Estimation of Multivariate Means with Heteroscedastic Error Using Envelope Models. Statistica Sinica, 23, 213-230.
  
  Cook, R. D., Li, B. and Chiaromente, F. (2010). Envelope Models for Parsimonious and Efficient Multivariate Linear Regression (with discussion). Statist. Sinica 20, 927- 1010.
  
  Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(waterstrider)
X <- waterstrider[ , 1]
Y <- waterstrider[ , 2:5]

\dontrun{u <- u.henv(X, Y)}
\dontrun{u}

\dontrun{m <- henv(X, Y, 2)}

}
