% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hMeanChiSq.R
\name{unirootAll}
\alias{unirootAll}
\title{Find multiple roots in interval}
\usage{
unirootAll(
  f,
  interval,
  lower = min(interval),
  upper = max(interval),
  n = 1000,
  tol = .Machine$double.eps^0.2,
  maxiter = 1000,
  trace = 0,
  ...
)
}
\arguments{
\item{f}{the function for which the root is sought.
\code{f} should be vectorized in the first argument.}

\item{interval}{A vector containing the end-points of the interval to be
searched for the root.}

\item{lower}{The lower end point of the interval to be searched.}

\item{upper}{The upper end point of the interval to be searched.}

\item{n}{Number of subintervals on which \code{link[stats]{uniroot}} is called.
Default is 1000.}

\item{tol}{See help of \code{link[stats]{uniroot}}.}

\item{maxiter}{See help of \code{link[stats]{uniroot}}.}

\item{trace}{See help of \code{link[stats]{uniroot}}.}

\item{...}{Additional named or unnamed arguments to be passed to \code{f}.}
}
\value{
A numeric vector of the roots found in the interval.
}
\description{
Searches the interval from lower to upper for several roots
(i.e., zero's) of a univariate function \code{f}.
}
\examples{
f <- function (x) cos(2*x)^3
(roots <- unirootAll(f = f, interval = c(0, 10)))
f(roots) 
}
\references{
This function is inspired by rootSolve::uniroot.all(),
package version 1.8.2.2.
}
\seealso{
\code{\link[base]{Vectorize}}
}
\author{
Florian Gerber
}
