/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTGraphicalObjectFrameLocking;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualGraphicFrameProperties;
import org.docx4j.dml.CTTable;
import org.docx4j.dml.CTTableCol;
import org.docx4j.dml.CTTableGrid;
import org.docx4j.dml.CTTableProperties;
import org.docx4j.dml.CTTableRow;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.tables.CellProperties;
import org.lysis.reporters.tables.FlexCell;
import org.lysis.reporters.tables.FlexRow;
import org.lysis.reporters.texts.ParProperties;
import org.lysis.reporters.texts.Paragraph;
import org.lysis.reporters.texts.ParagraphsSection;
import org.lysis.reporters.texts.TextProperties;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.CTGraphicalObjectFrameNonVisual;
import org.pptx4j.pml.ObjectFactory;

public class FlexTable
implements HTML4R {
    private LinkedHashMap<Integer, FlexRow> headerRowList;
    private int headerLines;
    private LinkedHashMap<Integer, FlexRow> footerRowList;
    private int footerLines;
    private int nrow;
    private int ncol;
    private ParagraphsSection[][] cellTextValue;
    private Integer[][] cellPropertiesIndex;
    private LinkedHashMap<Integer, CellProperties> cellProperties;
    protected LinkedHashMap<Integer, int[]> rowSpanInstructions;

    public FlexTable(int n, int c, String[] values, TextProperties tp, ParProperties pp, CellProperties cp) {
        this.cellTextValue = new ParagraphsSection[n][c];
        this.cellPropertiesIndex = new Integer[n][c];
        this.cellProperties = new LinkedHashMap();
        int cellpIndex = 0;
        this.cellProperties.put(cellpIndex, cp);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < c) {
                Paragraph par = new Paragraph();
                try {
                    par.addText(values[i * c + j], tp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.cellTextValue[i][j] = new ParagraphsSection(pp);
                this.cellTextValue[i][j].addParagraph(par);
                this.cellPropertiesIndex[i][j] = cellpIndex;
                ++j;
            }
            ++i;
        }
        this.headerLines = 0;
        this.headerRowList = new LinkedHashMap();
        this.footerLines = 0;
        this.footerRowList = new LinkedHashMap();
        this.nrow = n;
        this.ncol = c;
        this.rowSpanInstructions = new LinkedHashMap();
    }

    public void setRowSpanInstructions(int colindex, int[] x) {
        this.rowSpanInstructions.put(colindex, x);
    }

    public void addHeader(FlexRow fr) {
        this.headerRowList.put(this.headerLines, fr);
        ++this.headerLines;
    }

    public void addFooter(FlexRow fr) {
        this.footerRowList.put(this.footerLines, fr);
        ++this.footerLines;
    }

    public void resetHeader() {
        this.headerRowList.clear();
        this.headerLines = 0;
    }

    public void setBodyText(int i, int j, ParagraphsSection par) {
        this.cellTextValue[i][j] = par;
    }

    public void setCellProperties(int[] i, int[] j, CellProperties cp) {
        int li = i.length;
        int lj = j.length;
        int cellpIndex = this.cellProperties.size();
        this.cellProperties.put(cellpIndex, cp);
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellPropertiesIndex[i[row]][j[col]] = cellpIndex;
                ++col;
            }
            ++row;
        }
    }

    public void setParProperties(int[] i, int[] j, ParProperties pp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellTextValue[i[row]][j[col]].setParProperties(pp);
                ++col;
            }
            ++row;
        }
    }

    public void setTextProperties(int[] i, int[] j, TextProperties tp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellTextValue[i[row]][j[col]].setTextProperties(tp);
                ++col;
            }
            ++row;
        }
    }

    public int headerSize() {
        return this.headerLines;
    }

    public String toString() {
        String out = "";
        int i = 0;
        while (i < this.nrow) {
            out = String.valueOf(out) + "\n";
            int j = 0;
            while (j < this.ncol) {
                out = String.valueOf(out) + "\t" + this.cellTextValue[i][j].toString();
                ++j;
            }
            ++i;
        }
        return out;
    }

    private String HeaderHTML() {
        String out = "";
        out = String.valueOf(out) + "<thead>";
        int i = 0;
        while (i < this.headerLines) {
            out = String.valueOf(out) + this.headerRowList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</thead>";
        return out;
    }

    private String FooterHTML() {
        String out = "";
        out = String.valueOf(out) + "<tfoot>";
        int i = 0;
        while (i < this.footerLines) {
            out = String.valueOf(out) + this.footerRowList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</tfoot>";
        return out;
    }

    private void HeaderDOCX(Tbl reviewtable) {
        if (this.headerLines > 0) {
            int i = 0;
            while (i < this.headerLines) {
                Tr workingRow = this.headerRowList.get(i).getTr();
                TrPr trpr = new TrPr();
                List cnfStyleOrDivIdOrGridBefore = trpr.getCnfStyleOrDivIdOrGridBefore();
                cnfStyleOrDivIdOrGridBefore.add(Context.getWmlObjectFactory().createCTTrPrBaseTblHeader(Context.getWmlObjectFactory().createBooleanDefaultTrue()));
                workingRow.setTrPr(trpr);
                reviewtable.getContent().add(workingRow);
                ++i;
            }
        }
    }

    private void FooterDOCX(Tbl reviewtable) {
        if (this.footerLines > 0) {
            int i = 0;
            while (i < this.footerLines) {
                Tr workingRow = this.footerRowList.get(i).getTr();
                reviewtable.getContent().add(workingRow);
                ++i;
            }
        }
    }

    private void HeaderPPTX(CTTable reviewtable) throws Exception {
        if (this.headerLines < 1) {
            return;
        }
        int i = 0;
        while (i < this.headerLines) {
            CTTableRow workingRow = this.headerRowList.get(i).getCTTableRow();
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private void FooterPPTX(CTTable reviewtable) throws Exception {
        if (this.footerLines < 1) {
            return;
        }
        int i = 0;
        while (i < this.footerLines) {
            CTTableRow workingRow = this.footerRowList.get(i).getCTTableRow();
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private void BodyDOCX(Tbl reviewtable) {
        int i = 0;
        while (i < this.nrow) {
            Tr workingRow = new Tr();
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellProperties.get(this.cellPropertiesIndex[i][j]));
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                workingRow.getContent().add(fc.getTc());
                ++j;
            }
            reviewtable.getContent().add(workingRow);
            ++i;
        }
    }

    private void BodyPPTX(CTTable reviewtable) throws Exception {
        int i = 0;
        while (i < this.nrow) {
            CTTableRow workingRow = new CTTableRow();
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellProperties.get(this.cellPropertiesIndex[i][j]));
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                workingRow.getTc().add(fc.getCTTableCell());
                ++j;
            }
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private String BodyHTML() {
        String out = "";
        out = String.valueOf(out) + "<tbody>";
        int i = 0;
        while (i < this.nrow) {
            out = String.valueOf(out) + "<tr>";
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellProperties.get(this.cellPropertiesIndex[i][j]));
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                out = String.valueOf(out) + fc.getHTML();
                ++j;
            }
            out = String.valueOf(out) + "</tr>";
            ++i;
        }
        out = String.valueOf(out) + "</tbody>";
        return out;
    }

    public CTTable getPptxTbl(long width) throws Exception {
        CTTable newTable = new CTTable();
        CTTableProperties tablpro = new CTTableProperties();
        CTTableGrid tg = new CTTableGrid();
        int i = 0;
        while (i < this.ncol) {
            List gc = tg.getGridCol();
            CTTableCol tc = new CTTableCol();
            tc.setW(width);
            gc.add(tc);
            ++i;
        }
        newTable.setTblPr(tablpro);
        newTable.setTblGrid(tg);
        if (this.nrow > 0) {
            this.HeaderPPTX(newTable);
            this.BodyPPTX(newTable);
            this.FooterPPTX(newTable);
        }
        return newTable;
    }

    public CTGraphicalObjectFrame getShape(long idx, long shape_id, long width) throws Exception {
        org.docx4j.dml.ObjectFactory dmlFactory = new org.docx4j.dml.ObjectFactory();
        ObjectFactory pmlFactory = new ObjectFactory();
        CTGraphicalObjectFrame graphicFrame = pmlFactory.createCTGraphicalObjectFrame();
        CTGraphicalObjectFrameNonVisual nvGraphicFramePr = pmlFactory.createCTGraphicalObjectFrameNonVisual();
        CTNonVisualDrawingProps cNvPr = dmlFactory.createCTNonVisualDrawingProps();
        CTNonVisualGraphicFrameProperties cNvGraphicFramePr = dmlFactory.createCTNonVisualGraphicFrameProperties();
        CTGraphicalObjectFrameLocking graphicFrameLocks = new CTGraphicalObjectFrameLocking();
        CTTransform2D xfrm = dmlFactory.createCTTransform2D();
        Graphic graphic = dmlFactory.createGraphic();
        GraphicData graphicData = dmlFactory.createGraphicData();
        graphicFrame.setNvGraphicFramePr(nvGraphicFramePr);
        nvGraphicFramePr.setCNvPr(cNvPr);
        cNvPr.setName("nvGraphicFrame " + shape_id);
        cNvPr.setId(shape_id);
        nvGraphicFramePr.setCNvGraphicFramePr(cNvGraphicFramePr);
        cNvGraphicFramePr.setGraphicFrameLocks(graphicFrameLocks);
        graphicFrameLocks.setNoGrp(Boolean.valueOf(true));
        nvGraphicFramePr.setNvPr(pmlFactory.createNvPr());
        graphicFrame.setXfrm(xfrm);
        graphicFrame.setGraphic(graphic);
        graphic.setGraphicData(graphicData);
        graphicData.setUri("http://schemas.openxmlformats.org/drawingml/2006/table");
        CTTable ctTable = this.getPptxTbl(new Double(width / (long)this.ncol).longValue());
        JAXBElement tbl = dmlFactory.createTbl(ctTable);
        graphicData.getAny().add(tbl);
        return graphicFrame;
    }

    public Tbl getDocxTbl() {
        Tbl newTable = new Tbl();
        this.HeaderDOCX(newTable);
        this.BodyDOCX(newTable);
        this.FooterDOCX(newTable);
        TblPr tblpr = new TblPr();
        Jc alignment = new Jc();
        alignment.setVal(JcEnumeration.CENTER);
        tblpr.setJc(alignment);
        newTable.setTblPr(tblpr);
        return newTable;
    }

    @Override
    public String getHTML() {
        String out = "<table>";
        out = String.valueOf(out) + this.HeaderHTML();
        out = String.valueOf(out) + this.BodyHTML();
        out = String.valueOf(out) + this.FooterHTML();
        out = String.valueOf(out) + "</table>";
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

