/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements.layouts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.docx4j.dml.CTTransform2D;
import org.lysis.reporters.pptx4r.elements.layouts.LayoutProperties;
import org.lysis.reporters.pptx4r.elements.layouts.ShapeDescription;

public class SlideLayout {
    public static int TITLE = 0;
    public static int FOOTER = 1;
    public static int SLIDENUMBER = 2;
    public static int DATE = 3;
    public static int SUBTITLE = 4;
    public static int CRTTITLE = 5;
    private Vector<Boolean> filledElement = new Vector();
    private int filledContent = 0;
    private int contentSize = 0;
    private LinkedHashMap<Integer, ShapeDescription> shapeDescriptionMetadata = new LinkedHashMap();
    private LinkedHashMap<Integer, ShapeDescription> shapeDescriptionContent = new LinkedHashMap();
    private HashMap<Integer, ShapeDescription> masterLayout;

    public SlideLayout(LayoutProperties slideLayout, HashMap<Integer, ShapeDescription> master) {
        this.filledElement.add(TITLE, false);
        this.filledElement.add(FOOTER, false);
        this.filledElement.add(SLIDENUMBER, false);
        this.filledElement.add(DATE, false);
        this.filledElement.add(SUBTITLE, false);
        this.filledElement.add(CRTTITLE, false);
        Vector<ShapeDescription> shapeDesc = slideLayout.getContents();
        for (ShapeDescription sd : shapeDesc) {
            if (sd.getShapeType().equals("title")) {
                this.shapeDescriptionMetadata.put(TITLE, sd);
            }
            if (sd.getShapeType().equals("dt")) {
                this.shapeDescriptionMetadata.put(DATE, sd);
            }
            if (sd.getShapeType().equals("ftr")) {
                this.shapeDescriptionMetadata.put(FOOTER, sd);
            }
            if (sd.getShapeType().equals("sldNum")) {
                this.shapeDescriptionMetadata.put(SLIDENUMBER, sd);
            }
            if (sd.getShapeType().equals("subTitle")) {
                this.shapeDescriptionMetadata.put(SUBTITLE, sd);
            }
            if (sd.getShapeType().equals("ctrTitle")) {
                this.shapeDescriptionMetadata.put(CRTTITLE, sd);
            }
            if (!sd.getShapeType().equals("body") && !sd.getShapeType().equals("tbl") && !sd.getShapeType().equals("obj") && !sd.getShapeType().equals("pic") && !sd.getShapeType().equals("undefined")) continue;
            this.shapeDescriptionContent.put(this.contentSize, sd);
            ++this.contentSize;
        }
        this.masterLayout = master;
    }

    public boolean contains(int what) {
        return this.shapeDescriptionMetadata.containsKey(what);
    }

    public boolean isFilled(int what) {
        return this.filledElement.get(what);
    }

    public void setFilled(int what) {
        this.filledElement.add(what, true);
    }

    public long id(int what) {
        return this.shapeDescriptionMetadata.get(what).getIdx();
    }

    public long idContent(int what) {
        Iterator<Map.Entry<Integer, ShapeDescription>> it = this.shapeDescriptionContent.entrySet().iterator();
        int index = 0;
        while (it.hasNext()) {
            ShapeDescription sd = it.next().getValue();
            if (index == what) {
                return sd.getIdx();
            }
            ++index;
        }
        System.err.println("cannot find content id");
        return -1L;
    }

    public int[] getContentDimensions(int id) {
        int[] data = new int[4];
        try {
            CTTransform2D xfrm = this.shapeDescriptionContent.get(id).getXfrm();
            Long offx = new Long(xfrm.getOff().getX());
            Long offy = new Long(xfrm.getOff().getY());
            Long extx = new Long(xfrm.getExt().getCx());
            Long exty = new Long(xfrm.getExt().getCy());
            data[0] = offx.intValue();
            data[1] = offy.intValue();
            data[2] = extx.intValue();
            data[3] = exty.intValue();
        }
        catch (NullPointerException e) {
            data[0] = -1;
            data[1] = -1;
            data[2] = -1;
            data[3] = -1;
        }
        return data;
    }

    public int[] getMetaDimensions(int id) {
        int[] data = new int[4];
        try {
            CTTransform2D xfrm = this.getXfrmMeta(id);
            Long offx = new Long(xfrm.getOff().getX());
            Long offy = new Long(xfrm.getOff().getY());
            Long extx = new Long(xfrm.getExt().getCx());
            Long exty = new Long(xfrm.getExt().getCy());
            data[0] = offx.intValue();
            data[1] = offy.intValue();
            data[2] = extx.intValue();
            data[3] = exty.intValue();
        }
        catch (NullPointerException e) {
            data[0] = -1;
            data[1] = -1;
            data[2] = -1;
            data[3] = -1;
        }
        return data;
    }

    public CTTransform2D getXfrmContent(int what) {
        return this.shapeDescriptionContent.get(what).getXfrm();
    }

    public CTTransform2D getXfrmMeta(int what) {
        CTTransform2D out;
        try {
            out = this.shapeDescriptionMetadata.get(what).getXfrm();
        }
        catch (NullPointerException e) {
            out = this.masterLayout.get(what).getXfrm();
        }
        return out;
    }

    public void setContentFilled() {
        ++this.filledContent;
    }

    public int getContentFilled() {
        return this.filledContent;
    }

    public int getContentSize() {
        return this.shapeDescriptionContent.size();
    }
}

