/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.docs;

import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.lysis.reporters.img.DrawingML;
import org.lysis.reporters.img.Image;
import org.lysis.reporters.pptx4r.elements.Date;
import org.lysis.reporters.pptx4r.elements.Footer;
import org.lysis.reporters.pptx4r.elements.SlideNumber;
import org.lysis.reporters.pptx4r.elements.SubTitle;
import org.lysis.reporters.pptx4r.elements.Title;
import org.lysis.reporters.pptx4r.elements.layouts.SlideLayout;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.tools.EMU;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;


public class SlideContent {
	
	public static int undefined = -1;
	public static int donotexists = 0;
	public static int isfilled = 1;
	public static int noproblem = 2;
	public static int noroomleft = 3;
	public static int undefdimension = 4;

	private SlidePart slidePart;
	private pptx4R itsPPTX;
	private long uidShape;	
	private String layoutName;
	private SlideLayout slideLayout;
	private int slideIndex;
	private long freeshapeid;
	

	public SlideContent( String masterName, pptx4R doc ) throws Exception{
		this.layoutName = masterName;
		this.slidePart = doc.getNewSlide(masterName);
		itsPPTX = doc;
		uidShape = -1;
		freeshapeid=0;
		slideLayout = new SlideLayout( doc.getLayoutProperties(masterName), doc.getMasterLayout());
		slideIndex = doc.getSlideNumber();
	}

	public SlideContent( String masterName, pptx4R doc, int slideIndex ) throws Exception{
		this.layoutName = masterName;
		this.slidePart = doc.getAndReInitExistingSlide(masterName, slideIndex);
		itsPPTX = doc;
		uidShape = -1;
		slideLayout = new SlideLayout( doc.getLayoutProperties(masterName), doc.getMasterLayout());
		this.slideIndex = slideIndex;
	}

	public int getmax_shape(){
		return slideLayout.getContentSize();
	}


	public int getNextShapeID(){
		long idx = slideLayout.idContent( slideLayout.getContentFilled()  );
		return (int)idx;
	}

	public int getNextIndex(){
		return slideLayout.getContentFilled();
	}
	
	public int addTitle( String title ) {

		boolean isCRT = false;
		if( !slideLayout.contains(SlideLayout.TITLE) && slideLayout.contains(SlideLayout.CRTTITLE) ) isCRT=true;

		if( !isCRT ){
		
			if( !slideLayout.contains(SlideLayout.TITLE) ) return donotexists;
			else if( slideLayout.isFilled(SlideLayout.TITLE) ) return isfilled;
			else if( slideLayout.contains(SlideLayout.TITLE) && !slideLayout.isFilled(SlideLayout.TITLE)){
				try{
					Shape sTitle = (Shape)Title.getShape(slideLayout.id(SlideLayout.TITLE), uidShape+1, title);
					slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
					slideLayout.setFilled(SlideLayout.TITLE);
					uidShape++;
					return noproblem;
				} catch(Exception e ) {
					return undefined;
				}
			}
			return undefined;
		} else {
			if( slideLayout.isFilled(SlideLayout.CRTTITLE) ) return isfilled;
			else if( slideLayout.contains(SlideLayout.CRTTITLE) && !slideLayout.isFilled(SlideLayout.CRTTITLE)){
				try{
					Shape sTitle = (Shape)Title.getShape(slideLayout.id(SlideLayout.CRTTITLE), uidShape+1, title);
					slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
					slideLayout.setFilled(SlideLayout.CRTTITLE);
					uidShape++;
					return noproblem;
				} catch(Exception e ) {
					return undefined;
				}
			}
			return undefined;
		}
	}

	public int addSubTitle(String title) {
		if (!slideLayout.contains(SlideLayout.SUBTITLE))
			return donotexists;
		else if (slideLayout.isFilled(SlideLayout.SUBTITLE))
			return isfilled;
		else if (slideLayout.contains(SlideLayout.SUBTITLE) && !slideLayout.isFilled(SlideLayout.SUBTITLE)) {
			try {
				Shape sTitle = (Shape) SubTitle.getShape( slideLayout.id(SlideLayout.SUBTITLE), uidShape+1, title);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
				slideLayout.setFilled(SlideLayout.SUBTITLE);
				uidShape++;
				return noproblem;
			} catch (Exception e) {
				return undefined;
			}
		}
		return undefined;
	}

	public int addDate( String date )  {
		if( !slideLayout.contains(SlideLayout.DATE) ) return donotexists;
		else if( slideLayout.isFilled(SlideLayout.DATE) ) return isfilled;
		else if( slideLayout.contains(SlideLayout.DATE) && !slideLayout.isFilled(SlideLayout.DATE)){
			try{
				Shape sDate = (Shape)Date.getShape(slideLayout.id(SlideLayout.DATE), uidShape+1, date);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sDate);
				slideLayout.setFilled(SlideLayout.DATE);
				uidShape++;
				return noproblem;
			} catch (Exception e) {
				return undefined;
			}
		}
		return undefined;
	}
	
	public int addSlideNumber( String slidenumber ) {
		if( !slideLayout.contains(SlideLayout.SLIDENUMBER) ) return donotexists;
		else if( slideLayout.isFilled(SlideLayout.SLIDENUMBER) ) return isfilled;
		else if( slideLayout.contains(SlideLayout.SLIDENUMBER) && !slideLayout.isFilled(SlideLayout.SLIDENUMBER)){
			try{
				Shape sSlideNumber = (Shape)SlideNumber.getShape(slideLayout.id(SlideLayout.SLIDENUMBER), uidShape+1, slidenumber);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sSlideNumber);	
				slideLayout.setFilled(SlideLayout.SLIDENUMBER);
				uidShape++;
				return noproblem;
			} catch (Exception e) {
				return undefined;
			}
		}
		return undefined;
	}
	
	public int addSlideNumber(  ) {
		return addSlideNumber(slideIndex+"");
	}
	
	public int addFooter( String footer ) {
		if( !slideLayout.contains(SlideLayout.FOOTER) ) return donotexists;
		else if( slideLayout.isFilled(SlideLayout.FOOTER) ) return isfilled;
		else if( slideLayout.contains(SlideLayout.FOOTER) && !slideLayout.isFilled(SlideLayout.FOOTER)){
			try{
				Shape sFooter = (Shape)Footer.getShape(slideLayout.id(SlideLayout.FOOTER), uidShape+1, footer);
				slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sFooter);
				slideLayout.setFilled(SlideLayout.FOOTER);
				uidShape++;
				return noproblem;
			} catch (Exception e) {
				return undefined;
			}
		}
		return undefined;
	}

	private CTTransform2D readXrfm(){
		int numContentFilled =slideLayout.getContentFilled();
		if( numContentFilled >= slideLayout.getContentSize() ) return null;
		return slideLayout.getXfrmContent(numContentFilled);
	}
	
	private boolean roomLeft(){
		int numContentFilled =slideLayout.getContentFilled();
		if( numContentFilled >= slideLayout.getContentSize() ) return false;
		else return true;
	}
	
	private void addIMG( Image img ) throws Exception {
		Pic shape = (Pic)img.get_pptx_elt( );
		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
	}
	
	public int add( Image img ) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		img.setPPTXMLPackage(itsPPTX.getBaseDocument());
		img.setPPTXSlidePart(slidePart);
		img.setXfrm(readXrfm());
		img.setUID(uidShape+1);
		img.setShapeID(uidShape+1);

		addIMG( img );
		
		uidShape = (int) img.nextUniqueId();
		slideLayout.setContentFilled();

		return noproblem;
	}
	
	
	public int add( Image img, double offx, double offy ) throws Exception {
		
		freeshapeid++;
		
		img.setPPTXMLPackage(itsPPTX.getBaseDocument());
		img.setPPTXSlidePart(slidePart);
		img.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		img.setExt(img.getCx(), img.getCy());
		img.setUID(freeshapeid+uidShape);
		img.setShapeID(freeshapeid+uidShape);

		addIMG( img );
		return noproblem;
		
	}

	public int add( Image img, double offx, double offy, double width, double height ) throws Exception {
		freeshapeid++;
		
		img.setPPTXMLPackage(itsPPTX.getBaseDocument());
		img.setPPTXSlidePart(slidePart);
		img.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		img.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		img.setUID(freeshapeid+uidShape);
		img.setShapeID(freeshapeid+uidShape);

		addIMG( img );
		return noproblem;
		
	}

	public int add( DrawingML d ) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		d.setPPTXMLPackage(itsPPTX.getBaseDocument());
		d.setPPTXSlidePart(slidePart);
		d.setXfrm(readXrfm());
		d.setUID(uidShape+1);
		d.setShapeID(uidShape+1);

		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame()
		.addAll(d.get_pptx_elt());
		slideLayout.setContentFilled();
		uidShape++;
		
		return noproblem;
	}
	
	public int add( DrawingML d, double offx, double offy, double width, double height ) throws Exception {
		
		freeshapeid++;
		
		d.setPPTXMLPackage(itsPPTX.getBaseDocument());
		d.setPPTXSlidePart(slidePart);
		d.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		d.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		d.setUID(freeshapeid+uidShape);
		d.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame()
		.addAll(d.get_pptx_elt( ));
		return noproblem;
	}
	
	
	public int[] getShapeDimensions(){
		int[] out = new int[4];
		out[0] = -1;out[1] = -1;out[2] = -1;out[3] = -1;
		
		int numContentFilled =slideLayout.getContentFilled();
		
		if( numContentFilled >= slideLayout.getContentSize() ) return out;
		else {
			CTTransform2D xfrm;
			xfrm = slideLayout.getXfrmContent(numContentFilled);
			out[0] = (int)(xfrm.getOff().getX());
			out[1] = (int)(xfrm.getOff().getY());
			out[2] = (int)(xfrm.getExt().getCx());
			out[3] = (int)(xfrm.getExt().getCy());
		}
		return out;
	}
	
	public int add( FlexTable obj ) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(readXrfm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		obj.setTableWidth(obj.getCx());
		
		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
		
		slideLayout.setContentFilled();
		uidShape++;
		return noproblem;
	}

	public int add( FlexTable obj, double offx, double offy, double width, double height ) throws Exception {
		freeshapeid++;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt( ));
		
		return noproblem;
	}
	
	public int add( ParagraphSet obj ) throws Exception {
		
		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(readXrfm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		
		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
		
		slideLayout.setContentFilled();
		uidShape++;
		return noproblem;
	}
	
	public int add( ParagraphSet obj, double offx, double offy, double width, double height ) throws Exception {
		freeshapeid++;

		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt( ));
		
		return noproblem;				
	}
	
	public int add( RScript obj ) throws Exception {

		if( !roomLeft() ) return noroomleft;
		
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setXfrm(readXrfm());
		obj.setUID(uidShape+1);
		obj.setShapeID(uidShape+1);
		
		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
		
		slideLayout.setContentFilled();
		uidShape++;
		return noproblem;
	}
	
	public int add( RScript obj, double offx, double offy, double width, double height ) throws Exception {		
		freeshapeid++;
		obj.setPPTXMLPackage(itsPPTX.getBaseDocument());
		obj.setPPTXSlidePart(slidePart);
		obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
		obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
		obj.setUID(freeshapeid+uidShape);
		obj.setShapeID(freeshapeid+uidShape);

		slidePart.getJaxbElement().getCSld().getSpTree()
		.getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt( ));
		
		return noproblem;
	}
	
	public String getLayoutName() {
		return layoutName;
	}
	
}
