/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import java.util.LinkedHashMap;
import java.util.Vector;

import org.docx4j.XmlUtils;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Shape;

public class ParagraphSet extends DocComponent implements HTML4R, PPTX4R, DOCX4R{
	
	private LinkedHashMap<Integer, Paragraph> parList;
	private String tag;
	
	private static String SAMPLE_SHAPE_START =                         
            "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\">"
            + "<p:nvSpPr>"
	            + "<p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" />"
		            + "<p:cNvSpPr>"
		                    + "<a:spLocks noGrp=\"${noGrp}\" />"
		            + "</p:cNvSpPr>"
	            + "<p:nvPr>"
                    + "<p:ph idx=\"${idx}\"/>"//+ "<p:ph idx=\"${idx}\" ${size}/>"
	            + "</p:nvPr>"
		    + "</p:nvSpPr>"
		    + "<p:spPr>"
		      + "<a:xfrm>"
		        + "<a:off x=\"${offx}\" y=\"${offy}\"/>"
		        + "<a:ext cx=\"${cx}\" cy=\"${cy}\"/>"
		      + "</a:xfrm>"
		    + "</p:spPr>"
		    + "<p:txBody>"
	            + "<a:bodyPr /><a:lstStyle />";
	private static String SAMPLE_SHAPE_END = "</p:txBody>" + "</p:sp>";
	
	public ParagraphSet( ParProperties parProp ){
		super();
		setParProperties(parProp);
		parList = new LinkedHashMap<Integer, Paragraph>();
		setParProperties( parProp );
		setTag("div");
	}
	
	public void addParagraph ( Paragraph par ){
		parList.put(size(), par);
	}
	
	public int size(){
		return parList.size() ;
	}
	
	public Paragraph getLast(){
		return parList.get(size()-1);
	}
	public void setTag( String t ){
		tag = t;
	}
	
	/* used with alterFlexTable */
	public void setTextProperties(TextProperties tp){
		if( size() > 0 )
			for(int i = 0 ; i < size() ; i++ ){
				parList.get(i).setTextProperties(tp);
			}
	}


	public String toString(){
		String out = "";
		if( size() > 0 )
			for(int i = 0 ; i < size() ; i++ ){
				out += parList.get(i).toString() ;
			}
		return out;
	}


	@Override
	public String getHTML() {
		if( size() < 1 ) return "";
		
		LinkedHashMap<String, String> ppr = getParProperties().get_html_pp();
		String out = "";
		String elt_tag_beg = "<p>";
		String elt_tag_end = "</p>";
		
		if( tag.equals("ul") || tag.equals("ol") ) {
			elt_tag_beg = "<li>";
			elt_tag_end = "</p>";
		} else if( tag.equals("pre") ) {
			elt_tag_beg = "";
			elt_tag_end = "";
		}
		
		if( !tag.equals("pre") ){
			out = "<" + tag + " style=\"";
			String styleStr = Format.getJSString(ppr);
			out = out + styleStr + "\">";
		} else {
			out = "<" + tag + ">";
		}
		
		for(int i = 0 ; i < size(); i++ ){
			out += elt_tag_beg + parList.get(i).getHTML() + elt_tag_end;
		}
		
		out += "</" + tag + ">";
		
		return out;
	}

	public Shape get_pptx_elt() throws Exception{
		
		if( !validatePPTXComponent() ) throw new Exception("class ParagraphSet: elements need to be set...");

		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("id_shape", shape_id + "" );
        mappings.put("title_shape", "Texts" + shape_id);
        mappings.put("idx", unique_id +"" );
        mappings.put("noGrp", "1" );
        mappings.put("cx", "" + getCx() );
        mappings.put("cy", "" + getCy() );
        mappings.put("offx", "" + getOffx() );
        mappings.put("offy", "" + getOffy() );

        Shape o = (Shape) XmlUtils.unmarshallFromTemplate(SAMPLE_SHAPE_START + "<a:p/>" + SAMPLE_SHAPE_END, mappings,Context.jcPML, Shape.class);
    	o.setTxBody(get_pptx_parset());

		return o;
	}
	
	public CTTextBody get_pptx_parset() throws Exception{
		CTTextParagraphProperties rpr = getParProperties().get_pptx_pp();
		Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				CTTextParagraph temp = parList.get(i).get_pptx_par();
				temp.setPPr(rpr);
				out.add( temp );
			}
		}
		CTTextBody tb = new CTTextBody();
		
		CTTextBodyProperties pp = new CTTextBodyProperties();
		CTTextListStyle ls = new CTTextListStyle();
		tb.setBodyPr(pp);
		tb.setLstStyle(ls);
		
		tb.getP().addAll(out);
		return tb;
	}
	
	public boolean validateDOCXComponent(){
		if( getPPr() == null ) {
			return false;
		}
		return true;
	}
	public Vector<P> get_docx_elt() throws Exception{
		Vector<P> out = new Vector<P>();
		
		if( !validateDOCXComponent() ) throw new Exception("class ParagraphSet: elements need to be set...");

		PPr rpr = getPPr();
		
		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				P temp = parList.get(i).get_docx_par();
				temp.setPPr(rpr);
				if( i == 1 ) addBookmark(temp);
				out.add( temp );
			}
		}
		
		return out;
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}





}
