/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;

public class RScript extends ParagraphSet implements HTML4R, PPTX4R, DOCX4R{

//	private static String SAMPLE_SHAPE_START =                         
//            "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\">"
//            + "<p:nvSpPr>"
//	            + "<p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" />"
//		            + "<p:cNvSpPr>"
//		                    + "<a:spLocks noGrp=\"${noGrp}\" />"
//		            + "</p:cNvSpPr>"
//	            + "<p:nvPr>"
//                    + "<p:ph idx=\"${idx}\"/>"//+ "<p:ph idx=\"${idx}\" ${size}/>"
//	            + "</p:nvPr>"
//		    + "</p:nvSpPr>"
//		    + "<p:spPr>"
//		      + "<a:xfrm>"
//		        + "<a:off x=\"0\" y=\"0\"/>"
//		        + "<a:ext cx=\"0\" cy=\"0\"/>"
//		      + "</a:xfrm>"
//		    + "</p:spPr>"
//		    + "<p:txBody>"
//	            + "<a:bodyPr /><a:lstStyle />";
//	private static String SAMPLE_SHAPE_END = "</p:txBody>" + "</p:sp>";

	
	public RScript( ParProperties parProp ){
		super(parProp);
	}


	@Override
	public String getHTML() {
		String out = "<pre style='text-align:left;'>";

		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				Paragraph p = get(i);
				p.setHTMLReference(list_id, counters, numbDefinition);
				p.setVanilla();
				out += p.getHTML() + "\n";
			}
		}
		
		out += "</pre>";
		
		return out;
	}

	
//	public Shape get_pptx_elt() throws Exception{
//		if( !validatePPTXComponent() ) throw new Exception("class RScript: elements need to be set...");
//
//		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
//        mappings.put("id_shape", shape_id + "" );
//        mappings.put("title_shape", "Texts" + shape_id);
//        mappings.put("idx", unique_id +"" );
//        mappings.put("noGrp", "1" );
//
//        Shape o = (Shape) XmlUtils.unmarshallFromTemplate(SAMPLE_SHAPE_START + "<a:p/>" + SAMPLE_SHAPE_END, mappings,org.pptx4j.jaxb.Context.jcPML, Shape.class);
//        
//		ParagraphSet temp = new ParagraphSet(getParProperties());
//		for( int i = 1 ; i <= size() ; i++ ){
//			temp.addParagraph(get(i));
//		}
//		
//    	o.setTxBody(temp.get_pptx_parset());
//        o.getSpPr().setXfrm(getXfrm());
//
//		return o;
//	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}


}
