/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.img;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.List;

import org.docx4j.XmlUtils;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.pml.Sld;

public class DrawingML extends DocComponent implements PPTX4R{
	private String filename;
	private int width, height;
	
	private static String pptx_model = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>"
					+ "<p:sld xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" "
						+ "xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" "
						+ "xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" >"
						+ "<p:cSld><p:spTree>"

						+ "<p:nvGrpSpPr>"
							+ "<p:cNvPr id=\"${id_shape}\" name=\"Plot ${id_shape}\" />"
							+ "<p:cNvGrpSpPr><a:grpSpLocks noResize=\"1\" noUngrp=\"1\" noChangeAspect=\"1\" /></p:cNvGrpSpPr>"
							+ "<p:nvPr />"
						+ "</p:nvGrpSpPr>"
						+ "<p:grpSpPr>"
							+ "<a:xfrm>"
								+ "<a:off x=\"0\" y=\"0\" />"
								+ "<a:ext cx=\"0\" cy=\"0\" />"
								+ "<a:chOff x=\"0\" y=\"0\" />"
								+ "<a:chExt cx=\"0\" cy=\"0\" />"
							+ "</a:xfrm>"
						+ "</p:grpSpPr>"
						+ "<p:grpSp>"
							+ "<p:nvGrpSpPr>"
								+ "<p:cNvPr id=\"${id_properties}\" name=\"Groupe ${id_properties}\" />"
								+ "<p:cNvGrpSpPr />"
								+ "<p:nvPr />"
							+ "</p:nvGrpSpPr>"
							+ "<p:grpSpPr>"
								+ "<a:xfrm>"
									+ "<a:off x=\"${offx}\" y=\"${offy}\" />"
									+ "<a:ext cx=\"${cx}\" cy=\"${cy}\" />"
									+ "<a:chOff x=\"${offx}\" y=\"${offy}\" />"
									+ "<a:chExt cx=\"${cx}\" cy=\"${cy}\" />"
								+ "</a:xfrm>"
							+ "</p:grpSpPr>"
						+ "${content}"
						+ "</p:grpSp>"
						+ "</p:spTree></p:cSld>"
			+ "</p:sld>";
	
	private static String docx_model = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>"
		  	+ "<w:drawing xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" xmlns:w15=\"http://schemas.microsoft.com/office/word/2012/wordml\" xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\" mc:Ignorable=\"w14 w15 wp14\" >"
				+ "<wp:inline distT=\"0\" distB=\"0\" distL=\"0\" distR=\"0\">"
					+ "<wp:extent cx=\"${cx}\" cy=\"${cy}\" />"
					+ "<wp:docPr id=\"${id}\" name=\"Zone de dessin ${id}\" />"
					+ "<wp:cNvGraphicFramePr/>"
					+ "<a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\">"
						+ "<a:graphicData uri=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\">"
							+ "<wpg:wgp>"
								+ "<wpg:cNvGrpSpPr />"
								+ "<wpg:grpSpPr>"
									+ "<a:xfrm>"
										+ "<a:off x=\"0\" y=\"0\" />"
										+ "<a:ext cx=\"${cx}\" cy=\"${cy}\" />"
										+ "<a:chOff x=\"0\" y=\"0\" />"
										+ "<a:chExt cx=\"${cx}\" cy=\"${cy}\" />"
									+ "</a:xfrm>"
									+ "</wpg:grpSpPr>"
									+ "${content}"
							+ "</wpg:wgp>"
						+ "</a:graphicData>"
					+ "</a:graphic>"
				+ "</wp:inline>"
			+ "</w:drawing>";
	
	public boolean validateDOCXComponent(){
		if( getPPr() == null ) {
			return false;
		} else if( getCx() < 0 ) {
			return false;
		} else if( getCy() < 0 ) {
			return false;
		}
		
		return true;
	}
	
	public DrawingML(String filename){
		this.filename=filename;
	}
	
	public void setWidth(int w){
		width = w;
	}
	public void setHeight(int h){
		height = h;
	}
	
	public int getWidth(){
		return width;
	}
	public int getHeight(){
		return height;
	}
	
	public P get_docx_elt() throws Exception{
		
		String sCurrentLine;
		String data="";
		if( !validateDOCXComponent() ) throw new Exception("class DrawingML: elements need to be set...");
		BufferedReader br = new BufferedReader(new FileReader(filename));
		while ((sCurrentLine = br.readLine()) != null) {
			data = data + sCurrentLine;
		}
		br.close();

		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("cx", getCx() + "" );
        mappings.put("cy", getCy() + "");
        mappings.put("id", unique_id + "" );
        mappings.put("content", data );
        
        Drawing o = (Drawing) XmlUtils.unmarshallFromTemplate(docx_model, mappings,org.docx4j.jaxb.Context.jc, Drawing.class);

        P p = new P();

        R r = new R();
        r.getContent().add(o);
        p.getContent().add(r);
        
		addBookmark(p);
		
        p.setPPr(getPPr());
		return p;
	}
	
	public List<Object> get_pptx_elt() throws Exception{

		String sCurrentLine;
		String data="";
		if( !validatePPTXComponent() ) throw new Exception("class DrawingML: elements need to be set...");
		
		BufferedReader br = new BufferedReader(new FileReader(filename));
		while ((sCurrentLine = br.readLine()) != null) {
			data = data + sCurrentLine;
		}
		br.close();
		
		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("content", data );
        mappings.put("id_shape", shape_id + "" );
        mappings.put("id_properties", unique_id + "" );
        mappings.put("offx", getOffx() + "" );
        mappings.put("offy", getOffy() + "" );
        mappings.put("cx", getCx() + "" );
        mappings.put("cy", getCy() + "" );
        Sld o = (Sld)org.docx4j.XmlUtils.unmarshallFromTemplate(pptx_model, mappings, org.pptx4j.jaxb.Context.jcPML, Sld.class) ;
		return o.getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
	}
	
}
