/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.docx4j.fonts.FontUtils;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontSetup;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.autodetect.FontFileFinder;
import org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.fonts.microsoft.MicrosoftFontsRegistry;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalFonts {
    protected static Logger log = LoggerFactory.getLogger(PhysicalFonts.class);
    protected static FontCache fontCache;
    private static final Map<String, PhysicalFont> physicalFontMap;
    private static final Map<String, PhysicalFont> physicalFontMapByFilenameLowercase;
    private static FontResolver fontResolver;
    private static FontInfoFinder fontInfoFinder;
    private static String osName;
    private static String regex;
    private static boolean loggedWarningAlready;

    public static Map<String, PhysicalFont> getPhysicalFonts() {
        return physicalFontMap;
    }

    public static String getRegex() {
        return regex;
    }

    public static void setRegex(String regex) {
        PhysicalFonts.regex = regex;
    }

    public static final void discoverPhysicalFonts() throws Exception {
        URL fontUrl;
        Iterator iter;
        FontFileFinder fontFileFinder = new FontFileFinder();
        List fontFileList = fontFileFinder.find();
        if (regex == null) {
            iter = fontFileList.iterator();
            while (iter.hasNext()) {
                fontUrl = PhysicalFonts.getURL(iter.next());
                PhysicalFonts.addPhysicalFont(fontUrl);
            }
        } else {
            Pattern pattern = Pattern.compile(regex);
            Iterator iter2 = fontFileList.iterator();
            while (iter2.hasNext()) {
                URL fontUrl2 = PhysicalFonts.getURL(iter2.next());
                if (pattern.matcher(fontUrl2.toString()).matches()) {
                    PhysicalFonts.addPhysicalFont(fontUrl2);
                    continue;
                }
                log.debug("Ignoring " + fontUrl2.toString());
            }
        }
        fontFileList = fontFileFinder.find(ObfuscatedFontPart.getTemporaryEmbeddedFontsDir());
        iter = fontFileList.iterator();
        while (iter.hasNext()) {
            fontUrl = PhysicalFonts.getURL(iter.next());
            PhysicalFonts.addPhysicalFont(fontUrl);
        }
        fontCache.save();
    }

    private static URL getURL(Object o) throws Exception {
        if (o instanceof File) {
            File f = (File)o;
            return f.toURL();
        }
        if (o instanceof URL) {
            return (URL)o;
        }
        throw new Exception("Unexpected object:" + o.getClass().getName());
    }

    public static void addPhysicalFont(URL fontUrl) {
        PhysicalFonts.addPhysicalFont(null, fontUrl);
    }

    public static void addPhysicalFont(String nameAsInFontTablePart, URL fontUrl) {
        EmbedFontInfo[] embedFontInfoList = fontInfoFinder.find(fontUrl, fontResolver, fontCache);
        if (embedFontInfoList == null) {
            log.warn("Aborting: " + fontUrl.toString() + " (can't get EmbedFontInfo[] .. try deleting fop-fonts.cache?)");
            return;
        }
        StringBuffer debug = new StringBuffer();
        for (EmbedFontInfo fontInfo : embedFontInfoList) {
            block15: {
                if (fontInfo == null) continue;
                debug.append("------- \n");
                try {
                    debug.append(fontInfo.getPostScriptName() + "\n");
                    if (!fontInfo.isEmbeddable()) {
                        log.warn(fontInfo.getEmbedFile() + " is not embeddable; ignoring this font.");
                        continue;
                    }
                }
                catch (Exception e1) {
                    if (loggedWarningAlready) break block15;
                    log.warn("Not using patched FOP; isEmbeddable() method missing.");
                    loggedWarningAlready = true;
                }
            }
            FontTriplet triplet = (FontTriplet)fontInfo.getFontTriplets().get(0);
            String lower = fontInfo.getEmbedFile().toLowerCase();
            log.debug("Processing physical font: " + lower);
            debug.append(".. triplet " + triplet.getName() + " (priority " + triplet.getPriority() + "\n");
            PhysicalFont pf = null;
            if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.endsWith(".ttc")) {
                pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
            } else if (lower.endsWith(".pfb")) {
                String afm = FontUtils.pathFromURL(lower);
                afm = afm.substring(0, afm.length() - 4) + ".afm";
                log.debug("Looking for: " + afm);
                File f = new File(afm);
                if (f.exists()) {
                    log.debug(".. found");
                    pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                } else {
                    String pfm = FontUtils.pathFromURL(lower);
                    pfm = pfm.substring(0, pfm.length() - 4) + ".pfm";
                    log.debug("Looking for: " + pfm);
                    f = new File(pfm);
                    if (f.exists()) {
                        log.debug(".. found");
                        pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                    } else {
                        log.warn("Skipping " + triplet.getName() + "; couldn't find .afm or .pfm for : " + fontInfo.getEmbedFile());
                    }
                }
            } else {
                log.warn("Skipping " + triplet.getName() + "; unsupported type: " + fontInfo.getEmbedFile());
            }
            if (pf == null) continue;
            physicalFontMap.put(pf.getName(), pf);
            log.debug("Added " + pf.getName() + " -> " + pf.getEmbeddedFile());
            if (nameAsInFontTablePart != null && !physicalFontMap.containsKey(nameAsInFontTablePart)) {
                physicalFontMap.put(nameAsInFontTablePart, pf);
                log.debug("Added '" + nameAsInFontTablePart + "' -> " + pf.getEmbeddedFile());
            }
            String filename = pf.getEmbeddedFile();
            filename = filename.substring(filename.lastIndexOf("/") + 1).toLowerCase();
            if (osName.startsWith("Mac")) {
                filename = filename.replace("%20", " ");
            }
            physicalFontMapByFilenameLowercase.put(filename, pf);
            log.debug("added to filename map: " + filename);
        }
        log.debug(debug.toString());
    }

    public static PhysicalFont getBoldForm(PhysicalFont pf) {
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getBold() == null) {
            log.debug("No bold form for: " + pf.getName());
            return null;
        }
        String filename = osName.startsWith("Mac") ? msFont.getBold().getMac().toLowerCase() : msFont.getBold().getFilename().toLowerCase();
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getBoldItalicForm(PhysicalFont pf) {
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getBolditalic() == null) {
            log.debug("No Bolditalic form for: " + pf.getName());
            return null;
        }
        String filename = osName.startsWith("Mac") ? msFont.getBolditalic().getMac().toLowerCase() : msFont.getBolditalic().getFilename().toLowerCase();
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getItalicForm(PhysicalFont pf) {
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.debug("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getItalic() == null) {
            log.info("No italic form for: " + pf.getName());
            return null;
        }
        String filename = osName.startsWith("Mac") ? msFont.getItalic().getMac().toLowerCase() : msFont.getItalic().getFilename().toLowerCase();
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static String getPhysicalFont(OpcPackage wmlPackage, String fontName) {
        log.debug("looking for: " + fontName);
        if (!(wmlPackage instanceof WordprocessingMLPackage)) {
            log.error("Implement me for pptx4j");
            return null;
        }
        PhysicalFont pf = ((WordprocessingMLPackage)wmlPackage).getFontMapper().getFontMappings().get(fontName);
        if (pf != null) {
            log.debug("Font '" + fontName + "' maps to " + pf.getName());
            return pf.getName();
        }
        log.warn("Font '" + fontName + "' is not mapped to a physical font. ");
        return null;
    }

    public static void main(String[] args) throws Exception {
        PhysicalFonts.discoverPhysicalFonts();
        System.out.println("That should have listed your physical fonts (provided you have logging enabled).");
    }

    static {
        try {
            osName = System.getProperty("os.name");
            fontCache = FontCache.load();
            if (fontCache == null) {
                fontCache = new FontCache();
            }
            physicalFontMap = new HashMap<String, PhysicalFont>();
            physicalFontMapByFilenameLowercase = new HashMap<String, PhysicalFont>();
            fontResolver = FontSetup.createMinimalFontResolver();
            fontInfoFinder = new FontInfoFinder();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        loggedWarningAlready = false;
    }
}

