/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.PageSequenceResults;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.fo.AbstractPlaceholderLookup;
import org.docx4j.convert.out.fo.PlaceholderReplacementHandler;
import org.docx4j.fonts.fop.util.FopConfigUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheFORenderer
implements FORenderer {
    protected static Logger log = LoggerFactory.getLogger(ApacheFORenderer.class);
    protected static ApacheFORenderer instance = null;

    @Override
    public void render(String foDocument, FOSettings settings, boolean twoPass, List<FORenderer.SectionPageInformation> pageNumberInformation, OutputStream outputStream) throws Docx4JException {
        String apacheFopConfiguration = this.setupApacheFopConfiguration(settings);
        String apacheFopMime = this.setupApacheFopMime(settings);
        StreamSource foDocumentSrc = new StreamSource(new StringReader(foDocument));
        FopPlaceholderLookup placeholderLookup = null;
        FormattingResults formattingResults = null;
        FopFactory fopFactory = null;
        try {
            fopFactory = this.getFopFactory(apacheFopConfiguration);
        }
        catch (FOPException e) {
            throw new Docx4JException("Exception creating fop factory for rendering: " + e.getMessage(), (Exception)((Object)e));
        }
        if (twoPass) {
            log.debug("1st pass in 2 pass");
            placeholderLookup = new FopPlaceholderLookup(pageNumberInformation);
            formattingResults = this.calcResults(fopFactory, apacheFopMime, foDocumentSrc, placeholderLookup);
            placeholderLookup.setResults(formattingResults);
            foDocumentSrc = new StreamSource(new StringReader(foDocument));
        }
        this.render(fopFactory, apacheFopMime, foDocumentSrc, placeholderLookup, outputStream);
    }

    private String setupApacheFopConfiguration(FOSettings settings) throws Docx4JException {
        String ret = settings.getApacheFopConfiguration();
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)settings.getWmlPackage();
        if (ret == null) {
            ret = FopConfigUtil.createDefaultConfiguration(wmlPackage.getFontMapper(), wmlPackage.getMainDocumentPart().fontsInUse());
        }
        return ret;
    }

    private String setupApacheFopMime(FOSettings settings) {
        String ret = settings.getApacheFopMime();
        if (ret == null) {
            ret = "application/pdf";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FORenderer getInstance() {
        if (instance != null) return instance;
        Class<ApacheFORenderer> clazz = ApacheFORenderer.class;
        synchronized (ApacheFORenderer.class) {
            if (instance != null) return instance;
            instance = new ApacheFORenderer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void render(FopFactory fopFactory, String outputFormat, Source foDocumentSrc, PlaceholderReplacementHandler.PlaceholderLookup placeholderLookup, OutputStream outputStream) throws Docx4JException {
        Fop fop = null;
        SAXResult result = null;
        try {
            fop = fopFactory.newFop(outputFormat, outputStream);
            result = placeholderLookup == null ? new SAXResult(fop.getDefaultHandler()) : new SAXResult(new PlaceholderReplacementHandler(fop.getDefaultHandler(), placeholderLookup));
        }
        catch (FOPException e) {
            throw new Docx4JException("Exception setting up result for fo transformation: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            Transformer transformer = XmlUtils.getTransformerFactory().newTransformer();
            transformer.transform(foDocumentSrc, result);
        }
        catch (TransformerConfigurationException e) {
            throw new Docx4JException("Exception setting up transformer: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new Docx4JException("Exception executing transformer: " + e.getMessage(), e);
        }
    }

    protected FormattingResults calcResults(FopFactory fopFactory, String outputFormat, Source foDocumentSrc, PlaceholderReplacementHandler.PlaceholderLookup placeholderLookup) throws Docx4JException {
        Fop fop = null;
        SAXResult result = null;
        try {
            fop = fopFactory.newFop(outputFormat, (OutputStream)new NullOutputStream());
            result = new SAXResult(new PlaceholderReplacementHandler(fop.getDefaultHandler(), placeholderLookup));
        }
        catch (FOPException e) {
            throw new Docx4JException("Exception setting up result for fo transformation: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            Transformer transformer = XmlUtils.getTransformerFactory().newTransformer();
            transformer.transform(foDocumentSrc, result);
        }
        catch (TransformerConfigurationException e) {
            throw new Docx4JException("Exception setting up transformer: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new Docx4JException("Exception executing transformer: " + e.getMessage(), e);
        }
        return fop.getResults();
    }

    protected Fop createFop(String userConfiguration, String outputFormat, OutputStream outputStream) throws FOPException {
        FopFactory fopFactory = this.getFopFactory(userConfiguration);
        return fopFactory.newFop(outputFormat != null ? outputFormat : "application/pdf", outputStream);
    }

    protected FopFactory getFopFactory(String userConfig) throws FOPException {
        return this.createFopFactory(userConfig);
    }

    protected FopFactory createFopFactory(String userConfig) throws FOPException {
        InputStream is = null;
        try {
            is = IOUtils.toInputStream((String)userConfig, (String)"UTF-8");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        FopFactory fopFactory = null;
        try {
            Class<?> fopConfParserClass = Class.forName("org.apache.fop.apps.FopConfParser");
            URI defaultBaseURI = new URI("http://dummy.domain");
            Object o = fopConfParserClass.getConstructor(InputStream.class, URI.class).newInstance(is, defaultBaseURI);
            Method method = fopConfParserClass.getDeclaredMethod("getFopFactoryBuilder", new Class[0]);
            Object fopFactoryBuilder = method.invoke(o, new Object[0]);
            Class<?> fopFactoryBuilderClass = Class.forName("org.apache.fop.apps.FopFactoryBuilder");
            method = fopFactoryBuilderClass.getDeclaredMethod("build", new Class[0]);
            fopFactory = (FopFactory)method.invoke(fopFactoryBuilder, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Can't set up FOP svn; " + e.getMessage());
            log.debug(e.getMessage(), (Throwable)e);
            try {
                Class[] params = new Class[1];
                Method method = FopFactory.class.getDeclaredMethod("newInstance", new Class[0]);
                fopFactory = (FopFactory)method.invoke(null, new Object[0]);
                params[0] = Configuration.class;
                method = FopFactory.class.getDeclaredMethod("setUserConfig", params);
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                method.invoke((Object)fopFactory, cfgBuilder.build(is));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return fopFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FopPlaceholderLookup
    extends AbstractPlaceholderLookup {
        public FopPlaceholderLookup(List<FORenderer.SectionPageInformation> pageNumberInformation) {
            super(pageNumberInformation);
        }

        public void setResults(FormattingResults formattingResults) throws Docx4JException {
            List resultList = null;
            PageSequenceResults pageSequenceResults = null;
            if (formattingResults == null) {
                throw new Docx4JException("Apache fop returned no FormattingResults (null)");
            }
            resultList = formattingResults.getPageSequences();
            if (resultList == null) {
                throw new Docx4JException("Apache fop returned null pageSequences");
            }
            if (resultList.size() != this.pageNumberInformation.size()) {
                throw new Docx4JException("Apache fop returned different count of sections than expected, returned: " + resultList.size() + ", expected: " + this.pageNumberInformation.size());
            }
            this.putDocumentPageCount(formattingResults.getPageCount());
            for (int i = 0; i < formattingResults.getPageSequences().size(); ++i) {
                pageSequenceResults = (PageSequenceResults)resultList.get(i);
                this.putSectionPageCount(i, pageSequenceResults.getPageCount());
            }
        }
    }
}

