/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderGIF
extends AbstractImagePreloader {
    private static final int GIF_SIG_LENGTH = 10;

    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException {
        boolean supported;
        if (!ImageUtil.hasImageInputStream(src)) {
            return null;
        }
        ImageInputStream in = ImageUtil.needImageInputStream(src);
        byte[] header = this.getHeader(in, 10);
        boolean bl = supported = header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56 && (header[4] == 55 || header[4] == 57) && header[5] == 97;
        if (supported) {
            ImageInfo info = new ImageInfo(uri, "image/gif");
            info.setSize(this.determineSize(header, context));
            return info;
        }
        return null;
    }

    private ImageSize determineSize(byte[] header, ImageContext context) {
        int byte1 = header[6] & 0xFF;
        int byte2 = header[7] & 0xFF;
        int width = (byte2 << 8 | byte1) & 0xFFFF;
        byte1 = header[8] & 0xFF;
        byte2 = header[9] & 0xFF;
        int height = (byte2 << 8 | byte1) & 0xFFFF;
        ImageSize size = new ImageSize(width, height, context.getSourceResolution());
        size.calcSizeFromPixels();
        return size;
    }
}

