/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.ArrayUtils;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovalHandler {
    private static final String templateFile = RemovalHandler.class.getName().replace('.', '/') + ".xslt";
    private final Templates removalTemplate;

    public RemovalHandler() {
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(templateFile);
        StreamSource templateSource = new StreamSource(templateStream);
        try {
            this.removalTemplate = XmlUtils.getTransformerTemplate(templateSource);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Error instantiating SDT removal stylesheet", e);
        }
    }

    public void removeSDTs(WordprocessingMLPackage wordMLPackage, Quantifier quantifier, String ... keys) throws Docx4JException {
        this.removeSDTs(wordMLPackage.getMainDocumentPart(), quantifier, keys);
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.removeSDTs((HeaderPart)rp.getPart(r), quantifier, keys);
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.removeSDTs((FooterPart)rp.getPart(r), quantifier, keys);
        }
    }

    public void removeSDTs(JaxbXmlPart<? extends Object> part, Quantifier quantifier, String ... keys) throws Docx4JException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("all", quantifier == Quantifier.ALL);
        if (quantifier == Quantifier.NAMED) {
            parameters.put("types", ArrayUtils.toString((Object)keys));
        }
        Document partDOM = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        JAXBResult result = XmlUtils.prepareJAXBResult(Context.jc);
        XmlUtils.transform(partDOM, this.removalTemplate, parameters, (Result)result);
        try {
            part.setJaxbElement(result);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Error unmarshalling document part for SDT removal", (Exception)((Object)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quantifier {
        ALL,
        NAMED,
        DEFAULT;

    }
}

