% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDep.R, R/pkgDep3.R
\name{pkgDepTopoSort}
\alias{pkgDepTopoSort}
\alias{pkgDep2}
\alias{pkgDep}
\title{Reverse package depends}
\usage{
pkgDepTopoSort(
  pkgs,
  deps,
  reverse = FALSE,
  topoSort = TRUE,
  libPaths,
  useAllInSearch = FALSE,
  returnFull = TRUE,
  recursive = TRUE,
  purge = getOption("Require.purge", FALSE),
  which = c("Depends", "Imports", "LinkingTo"),
  type = getOption("pkgType"),
  verbose = getOption("Require.verbose"),
  ...
)

pkgDep2(...)

pkgDep(
  packages,
  libPaths,
  which = c("Depends", "Imports", "LinkingTo"),
  recursive = TRUE,
  depends,
  imports,
  suggests,
  linkingTo,
  repos = getOption("repos"),
  keepVersionNumber = TRUE,
  includeBase = FALSE,
  includeSelf = TRUE,
  sort = TRUE,
  simplify = TRUE,
  purge = getOption("Require.purge", FALSE),
  verbose = getOption("Require.verbose"),
  type = getOption("pkgType"),
  Additional_repositories = FALSE,
  ...
)
}
\arguments{
\item{pkgs}{A vector of package names to evaluate their
reverse depends (i.e., the packages that \emph{use} each
of these packages)}

\item{deps}{An optional named list of (reverse) dependencies.
If not supplied, then \code{tools::dependsOnPkgs(..., recursive = TRUE)}
will be used}

\item{reverse}{Logical. If \code{TRUE}, then this will use \code{tools::pkgDependsOn}
to determine which packages depend on the \code{pkgs}}

\item{topoSort}{Logical. If \code{TRUE}, the default, then
the returned list of packages will be in order with the
least number of dependencies listed in \code{pkgs} at
the top of the list.}

\item{libPaths}{A path to search for installed packages. Defaults to
\code{.libPaths()}}

\item{useAllInSearch}{Logical. If \code{TRUE}, then all non-core
R packages in \code{search()} will be appended to \code{pkgs}
to allow those to also be identified}

\item{returnFull}{Logical. Primarily useful when \code{reverse = TRUE}.
If \code{TRUE}, then then all installed packages will be searched.
If \code{FALSE}, the default, only packages that are currently in
the \code{search()} path and passed in \code{pkgs} will be included
in the possible reverse dependencies.}

\item{recursive}{Logical. Should dependencies of dependencies be searched,
recursively. NOTE: Dependencies of suggests will not be recursive. Default
\code{TRUE}.}

\item{purge}{Logical. Should all caches be purged? Default is
\code{getOption("Require.purge", FALSE)}. There is a lot of internal caching of
results throughout the \code{Require} package. These help with speed and reduce
calls to internet sources. However, sometimes these caches must be purged.
The cached values are renewed when found to be too old, with the age limit.
This maximum age can be set in seconds with the environment variable
\code{R_AVAILABLE_PACKAGES_CACHE_CONTROL_MAX_AGE}, or if unset, defaults to 3600
(one hour -- see \code{\link[utils:available.packages]{utils::available.packages}}).

Internally, there are calls to \code{available.packages}.}

\item{which}{a character vector listing the types of dependencies, a subset
of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector, character string
\code{"most"} for the same vector without \code{"Enhances"}.}

\item{type}{See \code{utils::install.packages}}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}

\item{...}{Currently only \code{dependencies} as an alternative to \code{which}. If specified,
then \code{which} will be ignored.}

\item{packages}{Either a character vector of packages to install via
\code{install.packages}, then load (i.e., with \code{library}), or, for convenience,
a vector or list (using \code{c} or \code{list}) of unquoted package names to install
and/or load (as in \code{require}, but vectorized). Passing vectors of names may
not work in all cases, so user should confirm before relying on this behaviour
in operational code.
In the case of a GitHub package, it
will be assumed that the name of the repository is the name of the package.
If this is not the case, then pass a \emph{named} character vector here, where the
names are the package names that could be different than the GitHub
repository name.}

\item{depends}{Logical. Include packages listed in "Depends". Default \code{TRUE}.}

\item{imports}{Logical. Include packages listed in "Imports". Default \code{TRUE}.}

\item{suggests}{Logical. Include packages listed in "Suggests". Default
\code{FALSE}.}

\item{linkingTo}{Logical. Include packages listed in "LinkingTo". Default
\code{TRUE}.}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to either
\code{install.packages}, \code{install_github} or \code{installVersions}.}

\item{keepVersionNumber}{Logical. If \code{TRUE}, then the package dependencies
returned will include version number. Default is \code{FALSE}}

\item{includeBase}{Logical. Should R base packages be included, specifically,
those in \code{tail(.libPaths(), 1)}}

\item{includeSelf}{Logical. If \code{TRUE}, the default, then the dependencies
will include the package itself in the returned list elements, otherwise,
only the "dependencies"}

\item{sort}{Logical. If \code{TRUE}, the default, then the packages will be sorted
alphabetically. If \code{FALSE}, the packages will not have a discernible order
as they will be a concatenation of the possibly recursive package
dependencies.}

\item{simplify}{Logical or numeric. If \code{TRUE} (or > 0), the default,
the return object is "just" a character vector of package names
(with version requirements). If \code{FALSE} (or \code{0}),
then a \code{data.table} will be returned with 4 columns,
\code{Package}, \code{packageFullName}, \code{parentPackage} (the package name for which the
given line entry is a dependency; will be "user" if it was user supplied)
and \code{deps}, which is a list of \code{data.table}s
of all dependencies. If a negative number, then it will return a similar \code{data.table}
as with \code{FALSE}, however, duplications in the recursive package dependencies
are left intact.}

\item{Additional_repositories}{Logical. If \code{TRUE}, then \code{pkgDep} will return
a list of \code{data.table} objects (instead of character vectors)
with a column \code{packageFullName} and possibly a second column \code{Additional_repositories},
which may have been specified in a \code{DESCRIPTION} file. NOTE: THIS ALTERS
THE OUTPUT CLASS}
}
\value{
A possibly ordered, named (with packages as names) list where list elements
are either full reverse depends.
}
\description{
This is a wrapper around \code{tools::dependsOnPkgs},
but with the added option of \code{topoSort}, which
will sort them such that the packages at the top will have
the least number of dependencies that are in \code{pkgs}.
This is essentially a topological sort, but it is done
heuristically. This can be used to e.g., \code{detach} or
\code{unloadNamespace} packages in order so that they each
of their dependencies are detached or unloaded first.

\code{pkgDep2} is a convenience wrapper of \code{pkgDep} that "goes one level in",
i.e., the first order dependencies, and runs the \code{pkgDep} on those.

This will first look in local filesystem (in \code{.libPaths()}) and will use a
local package to find its dependencies. If the package does not exist
locally, including whether it is the correct version, then it will look in
(currently) \code{CRAN} and its archives (if the current \code{CRAN} version is not the
desired version to check). It will also look on \code{GitHub} if the package
description is of the form of a GitHub package with format
\code{account/repo@branch} or \code{account/repo@commit}. For this, it will attempt to
get package dependencies from the GitHub \file{DESCRIPTION} file. This is
intended to replace \code{tools::package_dependencies} or \code{pkgDep} in the
\pkg{miniCRAN} package, but with modifications to allow multiple sources to
be searched in the same function call.
}
\note{
\code{tools::package_dependencies} and \code{pkgDep} will differ under the
following circumstances: \enumerate{ \item GitHub packages are not detected
using \code{tools::package_dependencies}; \item \code{tools::package_dependencies}
does not detect the dependencies of base packages among themselves, \emph{e.g.},
\code{methods} depends on \code{stats} and \code{graphics}. }
}
\examples{
\dontrun{
if (Require:::.runLongExamples()) {
  opts <- Require:::.setupExample()

  pkgDepTopoSort(c("Require", "data.table"), reverse = TRUE)

  Require:::.cleanup(opts)
}
}

\dontrun{
if (Require:::.runLongExamples()) {
  opts <- Require:::.setupExample()

  pkgDep2("reproducible")
  # much bigger one
  pkgDep2("tidyverse")

  Require:::.cleanup(opts)
}
}
\dontrun{
if (Require:::.runLongExamples()) {
  opts <- Require:::.setupExample()

  pkgDep("tidyverse", recursive = TRUE)

  # GitHub, local, and CRAN packages
  pkgDep(c("PredictiveEcology/reproducible", "Require", "plyr"))

  Require:::.cleanup(opts)
}
}
}
