% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_boots_extract.R
\name{ResIN_boots_extract}
\alias{ResIN_boots_extract}
\title{ResIN_boots_extract}
\usage{
ResIN_boots_extract(ResIN_boots_executed, what, summarize_results = FALSE)
}
\arguments{
\item{ResIN_boots_executed}{A list of prepared ResIN objects for bootstrapping (outcome of the \code{ResIN_boots_executed} function)}

\item{what}{A character vector of length one specifying the target quantity of interest. This should be a one-to-one match with the corresponding output vector (or scalar) among the bootstrapped result list (see \code{ResIN_boots_execute}). For participants' position on the x-axis of the ResIN latent space, for example, specify "scores_x".}

\item{summarize_results}{Should the extracted quantities be summarized through a series of descriptive statistics? If set to true, the minimum, maximum, mean, selected quantiles, and the standard deviation are reported. If set to FALSE (default), extracted quantities are instead returned as a list.}
}
\value{
A list object containing n (bootstrapped) \code{ResIN} list objects.
}
\description{
Extract and summarize quantities from bootstrapped ResIN objects
}
\examples{
## Load the 12-item simulated Likert-type toy dataset
data(lik_data)

# Apply the ResIN function to toy Likert data:
ResIN_obj <- ResIN(lik_data, cor_method = "spearman", network_stats = TRUE,
                      generate_ggplot = FALSE)

\dontrun{
# Prepare for bootstrapping
prepped_boots <- ResIN_boots_prepare(ResIN_obj, n=5000, boots_type="permute")

# Execute the prepared bootstrap list
executed_boots <-  ResIN_boots_execute(prepped_boots, parallel = TRUE, detect_cores = TRUE)

# Extract results - here for example, the network (global)-clustering coefficient
ResIN_boots_extract(executed_boots, what = "global_clustering", summarize_results = TRUE)
}

}
