% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_to_gephi.R
\name{ResIN_to_gephi}
\alias{ResIN_to_gephi}
\title{ResIN_to_gephi}
\usage{
ResIN_to_gephi(ResIN_object, file = "ResIN_gephi.csv")
}
\arguments{
\item{ResIN_object}{the output of the ResIN function (a list with class ResIN).}

\item{file}{the name with .csv extension for the Gephi readable file to be output at. Defaults to "ResIN_gephi.csv".}
}
\value{
A series of csv files readable by Gephi
}
\description{
Saves a ResIN graph as a series of csv files readable by Gephi. Source code taken from RMHogervorst / gephi
}
\examples{

\dontrun{
## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)

## Run the function:
ResIN_to_gephi(ResIN(lik_data), file = "ResIN_gephi.csv")
}

}
\references{
Source code was taken from: https://github.com/RMHogervorst/gephi?tab=MIT-1-ov-file#readme
}
