% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupComparison.fn.R
\name{GroupComparison.fn}
\alias{GroupComparison.fn}
\title{Function to calculate the statistics for each Group}
\usage{
GroupComparison.fn(Data, GroupName, na.rm = TRUE, conf.level = 0.95)
}
\arguments{
\item{Data}{vector for response values}

\item{GroupName}{vector for group names}

\item{na.rm}{whether to remove value for calculation}

\item{conf.level}{confidence level}
}
\value{
a dataframe for the statistics for each Group. Number of Samples, mean

standard deviation (SD), median,  upper and lower bounds of CI, p-value of ANOVA
}
\description{
function to calculate the statistics for each Group: Number of Samples,
mean, standard deviation (SD), standard error (SE), median, confident interval, p-value of ANOVA
}
\examples{
data("HqData")
PP_Hq <- HqData
filenames <- row.names(PP_Hq)
q <- -10:10
ClassNames <- c(substr(filenames[1:19], start = 1, stop = 3),
                substr(filenames[20:38], start = 1, stop = 5))
Class <- unique(ClassNames)
Data <- GroupComparison.fn(PP_Hq[,1],ClassNames)
Data

}
