% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_est.R
\docType{methods}
\name{rc_est}
\alias{rc_est}
\title{Estimation of the Return Curve}
\usage{
rc_est(
  margdata,
  w = NULL,
  p,
  method = c("hill", "cl"),
  q = 0.95,
  qalphas = rep(0.95, 2),
  k = 7,
  constrained = FALSE,
  tol = 0.001,
  par_init = rep(0, k - 1)
)
}
\arguments{
\item{margdata}{An S4 object of class \code{margtransf.class}. See \code{\link{margtransf}} for more details.}

\item{w}{Sequence of rays between \code{0} and \code{1}. Default is \code{NULL}, where a pre-defined grid is used.}

\item{p}{Curve survival probability. Must be \mjeqn{p < 1-q}{p < 1-q} and \mjeqn{p < 1-q_\alpha}{p < 1-qalphas}.}

\item{method}{String that indicates which method is used for the estimation of the angular dependence function. Must either be \code{"hill"}, to use the Hill estimator \insertCite{Hill1975}{ReturnCurves}, or \code{"cl"} to use the smooth estimator based on Bernstein-Bezier polynomials estimated by composite maximum likelihood.}

\item{q}{Marginal quantile used to define the threshold \mjeqn{u_\omega}{} of the min-projection variable \mjeqn{T^1}{} at ray \mjeqn{\omega}{} \mjeqn{\left(t^1_\omega = t_\omega - u_\omega | t_\omega > u_\omega\right)}{}, and/or Hill estimator \insertCite{Hill1975}{ReturnCurves}. Default is \code{0.95}.}

\item{qalphas}{A vector containing the marginal quantile used for the Heffernan and Tawn conditional extremes model \insertCite{HeffernanTawn2004}{ReturnCurves} for each variable, if \code{constrained = TRUE}. Default is \code{rep(0.95, 2)}.}

\item{k}{Polynomial degree for the Bernstein-Bezier polynomials used for the estimation of the angular dependence function with the composite likelihood method \insertCite{MurphyBarltropetal2024}{ReturnCurves}. Default is \code{7}.}

\item{constrained}{Logical. If \code{FALSE} (default) no knowledge of the conditional extremes parameters is incorporated in the angular dependence function estimation.}

\item{tol}{Convergence tolerance for the composite maximum likelihood procedure. Success is declared when the difference of log-likelihood values between iterations does not exceed this value. Default is \code{0.0001}.}

\item{par_init}{Initial values for the parameters \mjeqn{\beta}{} of the Bernstein-Bezier polynomials used for estimation of the angular dependence function with the composite likelihood method \insertCite{MurphyBarltropetal2024}{ReturnCurves}. Default is \code{rep(0, k-1)}.}
}
\value{
An object of S4 class \code{rc_est.class}. This object returns the arguments of the function and extra slot \code{rc} 
\item{\code{interval}:}{A vector containing the maximum likelihood estimates from the conditional extremes model, \mjeqn{\hat{\alpha}^1_{x\mid y}}{} and \mjeqn{\hat{\alpha}^1_{y\mid x}}{}, if \code{constrained = TRUE}. If \code{constrained = FALSE}, then \code{c(0, 1)} is returned; we note that this has no meaningful interpretation as the estimation is performed in an unconstrained interval.}
\item{\code{rc}:}{A matrix with the estimates of the Return Curve.}
}
\description{
\loadmathjax{} Estimation of the \mjeqn{p}{p}-probability return curve following \insertCite{MurphyBarltropetal2023;textual}{ReturnCurves}.
}
\details{
Given a probability \mjeqn{p}{p} and a joint survival function \mjeqn{Pr(X>x, Y>y)}{}, 
the \mjeqn{p}{p}-probability return curve is defined as 
\mjdeqn{RC(p):=\left\lbrace(x, y) \in R^2: Pr(X>x, Y>y)=p\right\rbrace.}{} 

This method focuses on estimation of \mjeqn{RC(p)}{RC(p)} for small \mjeqn{p}{p} near \mjeqn{0}{0}, so that \mjeqn{(X,Y)}{} are in the tail of the distribution.

\mjeqn{Pr(X>x, Y>y)}{} is estimated using the angular dependence function \mjeqn{\lambda(\omega)}{} introduced by \insertCite{WadsworthTawn2013;textual}{ReturnCurves}. More details on how to estimate \mjeqn{\lambda(\omega)}{} can be found in \code{\link{adf_est}}.

The return curve estimation \mjeqn{\hat{RC}(p)}{} is done on standard exponential margins and then back transformed onto the original margins.
}
\examples{
library(ReturnCurves)

data(airdata)

n <- dim(airdata)[1]

prob <- 10/n

margdata <- margtransf(airdata)

retcurve <- rc_est(margdata = margdata, p = prob, method = "hill")

plot(retcurve)

# To see the the S4 object's slots
str(retcurve)

# To access the return curve estimation
retcurve@rc

# If constrained = T, the MLE estimates for the conditional extremes model
# can be accessed as
retcurve@interval

}
\references{
\insertAllCited{}
}
