% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_REDCap.R
\name{render_redcap_instrument}
\alias{render_redcap_instrument}
\title{Render REDCap Instrument}
\usage{
render_redcap_instrument(
  shinyREDCap_type,
  id,
  field_label,
  required,
  choices,
  current_subject_data = NULL,
  ...
)
}
\arguments{
\item{shinyREDCap_type}{A string indicating a supported shinyREDCap question type.
Valid options include: "shinyREDCap_text", "shinyREDCap_date", "shinyREDCap_dropdown",
"shinyREDCap_truefalse", "shinyREDCap_yesno", "shinyREDCap_radio", "shinyREDCap_checkbox",
"shinyREDCap_notes", "shinyREDCap_integer"}

\item{id}{A string, containing a globally unique REDCap question identifier. Used to
create a valid Shiny inputID.}

\item{field_label}{A string containing the question being asked. May contain
html formatting.}

\item{required}{A string, "yes" or "no". Is this a required REDCap question type?}

\item{choices}{REDCap choices for the question.}

\item{current_subject_data}{Previously saved REDCap data on the current subject.}

\item{...}{Any additional parameters to pass to shiny widget inputs.}
}
\value{
A shiny input widget for the UI
}
\description{
This function will select the appropriate shiny widget translation function
based on the provided parameters. Used to loop over REDCap project information
to create an entire data collection instrument which may consist of multiple
questions/question types.
}
\keyword{internal}
