% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{predict-multilayer-forestry}
\alias{predict-multilayer-forestry}
\alias{predict.multilayerForestry}
\title{predict-multilayer-forestry}
\usage{
\method{predict}{multilayerForestry}(
  object,
  newdata,
  aggregation = "average",
  seed = as.integer(runif(1) * 10000),
  nthread = 0,
  exact = NULL,
  ...
)
}
\arguments{
\item{object}{A `multilayerForestry` object.}

\item{newdata}{A data frame of testing predictors.}

\item{aggregation}{How shall the leaf be aggregated. The default is to return
the mean of the leave `average`. Other options are `weightMatrix` which
returns the adaptive nearest neighbor weights used to construct the predictions.}

\item{seed}{random seed}

\item{nthread}{The number of threads with which to run the predictions with.
This will default to the number of threads with which the forest was trained
with.}

\item{exact}{This specifies whether the forest predictions should be aggregated
in a reproducible ordering. Due to the non-associativity of floating point
addition, when we predict in parallel, predictions will be aggregated in
varied orders as different threads finish at different times.
By default, exact is TRUE unless N > 100,000 or a custom aggregation
function is used.}

\item{...}{additional arguments.}
}
\value{
A vector of predicted responses.
}
\description{
Return the prediction from the forest.
}
