% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_sphere.R
\name{sphere.convert}
\alias{sphere.convert}
\alias{sphere.geo2xyz}
\alias{sphere.xyz2geo}
\title{Convert between Cartesian Coordinates and Geographic Coordinates}
\usage{
sphere.geo2xyz(lat, lon)

sphere.xyz2geo(xyz)
}
\arguments{
\item{lat}{latitude (in decimal degrees).}

\item{lon}{longitude (in decimal degrees).}

\item{xyz}{a unit-norm vector in \eqn{\mathcal{S}^{2}}.}
}
\value{
transformed data.
}
\description{
In geospatial data analysis, it is common to consider locations on the Earth as 
data. These locations, usually provided by latitude and longitude, are not directly 
applicable for spherical data analysis. We provide two functions - \code{sphere.geo2xyz} and \code{sphere.xyz2geo} - 
that convert geographic coordinates in longitude/latitude into a unit-norm vector on \eqn{\mathcal{S}^2}, and vice versa. 
As a convention, latitude and longitude are represented as \emph{decimal degrees}.
}
\examples{
## EXAMPLE DATA WITH POPULATED US CITIES
data(cities)

## SELECT ALBUQUERQUE
geo = cities$coord[1,]
xyz = cities$cartesian[1,]

## CHECK TWO INPUT TYPES AND THEIR CONVERSIONS
sphere.geo2xyz(geo[1], geo[2])
sphere.xyz2geo(xyz)

}
\concept{sphere}
