% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_sphere_SL.R
\name{moSL}
\alias{moSL}
\alias{loglkd.moSL}
\alias{label.moSL}
\alias{density.moSL}
\title{Finite Mixture of Spherical Laplace Distributions}
\usage{
moSL(
  data,
  k = 2,
  same.sigma = FALSE,
  variants = c("soft", "hard", "stochastic"),
  ...
)

\method{loglkd}{moSL}(object, newdata)

\method{label}{moSL}(object, newdata)

\method{density}{moSL}(object, newdata)
}
\arguments{
\item{data}{data vectors in form of either an \eqn{(n\times p)} matrix or a length-\eqn{n} list.  See \code{\link{wrap.sphere}} for descriptions on supported input types.}

\item{k}{the number of clusters (default: 2).}

\item{same.sigma}{a logical; \code{TRUE} to use same scale parameter across all components, or \code{FALSE} otherwise.}

\item{variants}{type of the class assignment methods, one of \code{"soft"},\code{"hard"}, and \code{"stochastic"}.}

\item{...}{extra parameters including \describe{
\item{maxiter}{the maximum number of iterations (default: 50).}
\item{eps}{stopping criterion for the EM algorithm (default: 1e-6).}
\item{printer}{a logical; \code{TRUE} to show history of the algorithm, \code{FALSE} otherwise.}
}}

\item{object}{a fitted \code{moSL} model from the \code{\link{moSL}} function.}

\item{newdata}{data vectors in form of either an \eqn{(m\times p)} matrix or a length-\eqn{m} list.  See \code{\link{wrap.sphere}} for descriptions on supported input types.}
}
\value{
a named list of S3 class \code{riemmix} containing
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).}
\item{loglkd}{log likelihood of the fitted model.}
\item{criteria}{a vector of information criteria.}
\item{parameters}{a list containing \code{proportion}, \code{location}, and \code{scale}. See the section for more details.}
\item{membership}{an \eqn{(n\times k)} row-stochastic matrix of membership.}
}
}
\description{
For \eqn{n} observations on a \eqn{(p-1)} sphere in \eqn{\mathbf{R}^p}, 
a finite mixture model is fitted whose components are spherical Laplace distributions via the following model
\deqn{f(x; \left\lbrace w_k, \mu_k, \sigma_k \right\rbrace_{k=1}^K) = \sum_{k=1}^K w_k SL(x; \mu_k, \sigma_k)}
with parameters \eqn{w_k}'s for component weights, \eqn{\mu_k}'s for component locations, and \eqn{\sigma_k}'s for component scales.
}
\section{Parameters of the fitted model}{

A fitted model is characterized by three parameters. For \eqn{k}-mixture model on a \eqn{(p-1)} 
sphere in \eqn{\mathbf{R}^p}, (1) \code{proportion} is a length-\eqn{k} vector of component weight 
that sums to 1, (2) \code{location} is an \eqn{(k\times p)} matrix whose rows are per-cluster locations, and 
(3) \code{concentration} is a length-\eqn{k} vector of scale parameters for each component.
}

\section{Note on S3 methods}{

There are three S3 methods; \code{loglkd}, \code{label}, and \code{density}. Given a random sample of 
size \eqn{m} as \code{newdata}, (1) \code{loglkd} returns a scalar value of the computed log-likelihood, 
(2) \code{label} returns a length-\eqn{m} vector of cluster assignments, and (3) \code{density} 
evaluates densities of every observation according ot the model fit.
}

\examples{
\donttest{
# ---------------------------------------------------- #
#                 FITTING THE MODEL
# ---------------------------------------------------- #
# Load the 'city' data and wrap as 'riemobj'
data(cities)
locations = cities$cartesian
embed2    = array(0,c(60,2)) 
for (i in 1:60){
   embed2[i,] = sphere.xyz2geo(locations[i,])
}

# Fit the model with different numbers of clusters
k2 = moSL(locations, k=2)
k3 = moSL(locations, k=3)
k4 = moSL(locations, k=4)

# Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(embed2, col=k2$cluster, pch=19, main="K=2")
plot(embed2, col=k3$cluster, pch=19, main="K=3")
plot(embed2, col=k4$cluster, pch=19, main="K=4")
par(opar)

# ---------------------------------------------------- #
#                   USE S3 METHODS
# ---------------------------------------------------- #
# Use the same 'locations' data as new data 
# (1) log-likelihood
newloglkd = round(loglkd(k3, locations), 5)
fitloglkd = round(k3$loglkd, 5)
print(paste0("Log-likelihood for K=3 fitted    : ", fitloglkd))
print(paste0("Log-likelihood for K=3 predicted : ", newloglkd))

# (2) label
newlabel = label(k3, locations)

# (3) density
newdensity = density(k3, locations)
}

}
\concept{sphere}
