/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.EnhancedConnection;
import org.apache.activemq.advisory.DestinationEvent;
import org.apache.activemq.advisory.DestinationListener;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.camel.component.ActiveMQConfiguration;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CamelEndpointLoader
implements CamelContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelEndpointLoader.class);
    private CamelContext camelContext;
    private EnhancedConnection connection;
    private ConnectionFactory connectionFactory;
    private ActiveMQComponent component;

    public CamelEndpointLoader() {
    }

    public CamelEndpointLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        if (this.connection == null) {
            Connection value = this.getConnectionFactory().createConnection();
            if (value instanceof EnhancedConnection) {
                this.connection = (EnhancedConnection)value;
            } else {
                throw new IllegalArgumentException("Created JMS Connection is not an EnhancedConnection: " + value);
            }
        }
        this.connection.start();
        DestinationSource source = this.connection.getDestinationSource();
        source.setDestinationListener(new DestinationListener(){

            public void onDestinationEvent(DestinationEvent event) {
                try {
                    ActiveMQDestination destination = event.getDestination();
                    if (destination instanceof ActiveMQQueue) {
                        ActiveMQQueue queue = (ActiveMQQueue)destination;
                        if (event.isAddOperation()) {
                            CamelEndpointLoader.this.addQueue(queue);
                        } else {
                            CamelEndpointLoader.this.removeQueue(queue);
                        }
                    } else if (destination instanceof ActiveMQTopic) {
                        ActiveMQTopic topic = (ActiveMQTopic)destination;
                        if (event.isAddOperation()) {
                            CamelEndpointLoader.this.addTopic(topic);
                        } else {
                            CamelEndpointLoader.this.removeTopic(topic);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Caught: " + e, e);
                }
            }
        });
        Set<ActiveMQQueue> queues = source.getQueues();
        for (ActiveMQQueue queue : queues) {
            this.addQueue(queue);
        }
        Set<ActiveMQTopic> topics = source.getTopics();
        for (ActiveMQTopic topic : topics) {
            this.addTopic(topic);
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public EnhancedConnection getConnection() {
        return this.connection;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null && this.getComponent().getConfiguration() instanceof ActiveMQConfiguration) {
            this.connectionFactory = ((ActiveMQConfiguration)this.getComponent().getConfiguration()).createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ActiveMQComponent getComponent() {
        if (this.component == null) {
            this.component = (ActiveMQComponent)this.camelContext.getComponent("activemq", ActiveMQComponent.class);
        }
        return this.component;
    }

    public void setComponent(ActiveMQComponent component) {
        this.component = component;
    }

    protected void addQueue(ActiveMQQueue queue) throws Exception {
        String queueUri = this.getQueueUri(queue);
        ActiveMQComponent jmsComponent = this.getComponent();
        JmsQueueEndpoint endpoint = new JmsQueueEndpoint(queueUri, (JmsComponent)jmsComponent, queue.getPhysicalName(), jmsComponent.getConfiguration());
        this.camelContext.addEndpoint(queueUri, (Endpoint)endpoint);
    }

    protected String getQueueUri(ActiveMQQueue queue) {
        return "activemq:" + queue.getPhysicalName();
    }

    protected void removeQueue(ActiveMQQueue queue) throws Exception {
        String queueUri = this.getQueueUri(queue);
    }

    protected void addTopic(ActiveMQTopic topic) throws Exception {
        String topicUri = this.getTopicUri(topic);
        ActiveMQComponent jmsComponent = this.getComponent();
        JmsEndpoint endpoint = new JmsEndpoint(topicUri, (JmsComponent)jmsComponent, topic.getPhysicalName(), true, jmsComponent.getConfiguration());
        this.camelContext.addEndpoint(topicUri, (Endpoint)endpoint);
    }

    protected String getTopicUri(ActiveMQTopic topic) {
        return "activemq:topic:" + topic.getPhysicalName();
    }

    protected void removeTopic(ActiveMQTopic topic) throws Exception {
        String topicUri = this.getTopicUri(topic);
    }
}

