/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.PrintWriter;
import java.util.List;
import org.apache.activemq.openwire.tool.CppClassesGenerator;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;

public class CppHeadersGenerator
extends CppClassesGenerator {
    protected String getFilePostFix() {
        return ".hpp";
    }

    protected void generateFile(PrintWriter out) {
        String type;
        this.generateLicence(out);
        out.println("#ifndef ActiveMQ_" + this.className + "_hpp_");
        out.println("#define ActiveMQ_" + this.className + "_hpp_");
        out.println("");
        out.println("// Turn off warning message for ignored exception specification");
        out.println("#ifdef _MSC_VER");
        out.println("#pragma warning( disable : 4290 )");
        out.println("#endif");
        out.println("");
        out.println("#include <string>");
        out.println("#include \"activemq/command/" + this.baseClass + ".hpp\"");
        List<JProperty> properties = this.getProperties();
        for (JProperty property : properties) {
            JClass arrayType;
            if (property.getType().isPrimitiveType() || property.getType().getSimpleName().equals("String") || property.getType().getSimpleName().equals("ByteSequence")) continue;
            String includeName = this.toCppType(property.getType());
            if (property.getType().isArrayType() && (arrayType = property.getType().getArrayComponentType()).isPrimitiveType()) continue;
            if (includeName.startsWith("array<")) {
                includeName = includeName.substring(6, includeName.length() - 1);
            } else if (includeName.startsWith("p<")) {
                includeName = includeName.substring(2, includeName.length() - 1);
            }
            if (includeName.equals("IDataStructure")) {
                out.println("#include \"activemq/" + includeName + ".hpp\"");
                continue;
            }
            out.println("#include \"activemq/command/" + includeName + ".hpp\"");
        }
        out.println("");
        out.println("#include \"activemq/protocol/IMarshaller.hpp\"");
        out.println("#include \"ppr/io/IOutputStream.hpp\"");
        out.println("#include \"ppr/io/IInputStream.hpp\"");
        out.println("#include \"ppr/io/IOException.hpp\"");
        out.println("#include \"ppr/util/ifr/array\"");
        out.println("#include \"ppr/util/ifr/p\"");
        out.println("");
        out.println("namespace apache");
        out.println("{");
        out.println("  namespace activemq");
        out.println("  {");
        out.println("    namespace command");
        out.println("    {");
        out.println("      using namespace ifr;");
        out.println("      using namespace std;");
        out.println("      using namespace apache::activemq;");
        out.println("      using namespace apache::activemq::protocol;");
        out.println("      using namespace apache::ppr::io;");
        out.println("");
        out.println("/*");
        out.println(" *");
        out.println(" *  Command and marshalling code for OpenWire format for " + this.className + "");
        out.println(" *");
        out.println(" *");
        out.println(" *  NOTE!: This file is autogenerated - do not modify!");
        out.println(" *         if you need to make a change, please see the Groovy scripts in the");
        out.println(" *         activemq-core module");
        out.println(" *");
        out.println(" */");
        out.println("class " + this.className + " : public " + this.baseClass + "");
        out.println("{");
        out.println("protected:");
        for (JProperty property : properties) {
            type = this.toCppType(property.getType());
            String name = this.decapitalize(property.getSimpleName());
            out.println("    " + type + " " + name + " ;");
        }
        out.println("");
        out.println("public:");
        out.println("    const static unsigned char TYPE = " + this.getOpenWireOpCode(this.jclass) + ";");
        out.println("");
        out.println("public:");
        out.println("    " + this.className + "() ;");
        out.println("    virtual ~" + this.className + "() ;");
        out.println("");
        out.println("    virtual unsigned char getDataStructureType() ;");
        for (JProperty property : properties) {
            type = this.toCppType(property.getType());
            String propertyName = property.getSimpleName();
            String parameterName = this.decapitalize(propertyName);
            out.println("");
            out.println("    virtual " + type + " get" + propertyName + "() ;");
            out.println("    virtual void set" + propertyName + "(" + type + " " + parameterName + ") ;");
        }
        out.println("");
        out.println("    virtual int marshal(p<IMarshaller> marshaller, int mode, p<IOutputStream> ostream) throw (IOException) ;");
        out.println("    virtual void unmarshal(p<IMarshaller> marshaller, int mode, p<IInputStream> istream) throw (IOException) ;");
        out.println("} ;");
        out.println("");
        out.println("/* namespace */");
        out.println("    }");
        out.println("  }");
        out.println("}");
        out.println("");
        out.println("#endif /*ActiveMQ_" + this.className + "_hpp_*/");
    }
}

