/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.File;
import org.apache.activemq.openwire.tool.JavaMarshallingGenerator;
import org.apache.activemq.openwire.tool.JavaTestsGenerator;
import org.apache.activemq.openwire.tool.MultiSourceGenerator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class JavaGeneratorTask
extends Task {
    int version = 2;
    File basedir = new File(".");

    public static void main(String[] args) {
        Project project = new Project();
        project.init();
        JavaGeneratorTask generator = new JavaGeneratorTask();
        generator.setProject(project);
        if (args.length > 0) {
            generator.version = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            generator.basedir = new File(args[1]);
        }
        generator.execute();
    }

    public void execute() throws BuildException {
        try {
            String sourceDir = this.basedir + "/src/main/java";
            System.out.println("Parsing source files in: " + sourceDir);
            JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
            JamServiceParams params = jamServiceFactory.createServiceParams();
            File[] dirs = new File[]{new File(sourceDir)};
            params.includeSourcePattern(dirs, "**/*.java");
            JamService jam = jamServiceFactory.createService(params);
            MultiSourceGenerator script = new JavaMarshallingGenerator();
            script.setJam(jam);
            ((JavaMarshallingGenerator)script).setTargetDir(this.basedir + "/src/main/java");
            script.setOpenwireVersion(this.version);
            ((JavaMarshallingGenerator)script).run();
            script = new JavaTestsGenerator();
            script.setJam(jam);
            ((JavaTestsGenerator)script).setTargetDir(this.basedir + "/src/test/java");
            script.setOpenwireVersion(this.version);
            ((JavaTestsGenerator)script).run();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }
}

