% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialisation.R
\name{rlgtfit}
\alias{rlgtfit}
\title{rlgtfit class}
\usage{
rlgtfit(
  y,
  model.type,
  use.regression,
  seasonalityMethodId,
  levelMethodId,
  useSmoothingMethodForError = FALSE,
  seasonality,
  seasonality2,
  rlgtmodel,
  params,
  control,
  samples
)
}
\arguments{
\item{y}{time series data for training (provided as a vector or a ts object).}

\item{model.type}{the type of rlgt model, one of: "LGT", "SGT", "S2GT"}

\item{use.regression}{whether the data has any additional variables to be used with forecasting, i.e. multivariate time-series.}

\item{seasonalityMethodId}{Seasonality method Id (0- HW, 1- generalized).}

\item{levelMethodId}{Level method Id.}

\item{useSmoothingMethodForError}{if the non-standard function for error size should be used, one based on smoothed innovations or surprises}

\item{seasonality}{This specification of seasonality will be overridden by frequency of y, if y is of ts or msts class. 
1 by default, i.e. no seasonality.}

\item{seasonality2}{Second seasonality. If larger than 1, a dual seasonality model will be used. 
This specification of seasonality will be overridden by the second seasonality of y, if y is of msts class. 
1 by default, i.e. no seasonality or single seasonality.}

\item{rlgtmodel}{an rlgt model.}

\item{params}{list of parameters of the model (to be fitted).}

\item{control}{list of control parameters, i.e. hyperparameter values 
for the model's prior distribution. See \code{\link{rlgt.control}}}

\item{samples}{stanfit object representing the MCMC samples}
}
\value{
an rlgtfit instance
}
\description{
A constructor function for objects of class \code{rlgtfit}, the main class of the package. Objects of this class 
are output from the \code{\link{rlgt}} function. This constructor will usually not be called by users directly.
}
