% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsolve_GS.R
\name{lsolve.gs}
\alias{lsolve.gs}
\title{Gauss-Seidel method}
\usage{
lsolve.gs(
  A,
  B,
  xinit = NA,
  reltol = 1e-05,
  maxiter = 1000,
  adjsym = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{A}{an \eqn{(m\times n)} dense or sparse matrix. See also \code{\link[Matrix]{sparseMatrix}}.}

\item{B}{a vector of length \eqn{m} or an \eqn{(m\times k)} matrix (dense or sparse) for solving \eqn{k} systems simultaneously.}

\item{xinit}{a length-\eqn{n} vector for initial starting point. \code{NA} to start from a random initial point near 0.}

\item{reltol}{tolerance level for stopping iterations.}

\item{maxiter}{maximum number of iterations allowed.}

\item{adjsym}{a logical; \code{TRUE} to symmetrize the system by transforming the system into normal equation, \code{FALSE} otherwise.}

\item{verbose}{a logical; \code{TRUE} to show progress of computation.}
}
\value{
a named list containing \describe{
\item{x}{solution; a vector of length \eqn{n} or a matrix of size \eqn{(n\times k)}.}
\item{iter}{the number of iterations required.}
\item{errors}{a vector of errors for stopping criterion.}
}
}
\description{
Gauss-Seidel(GS) method is an iterative algorithm for solving a system of linear equations,
with a decomposition \eqn{A = D+L+U} where \eqn{D} is a diagonal matrix and
\eqn{L} and {U} are strictly lower/upper triangular matrix respectively.
For a square matrix \eqn{A}, it is required to be diagonally dominant or symmetric and positive definite.
For an overdetermined system where \code{nrow(A)>ncol(A)},
it is automatically transformed to the normal equation. Underdetermined system -
\code{nrow(A)<ncol(A)} - is not supported.
}
\examples{
## Overdetermined System
set.seed(100)
A = matrix(rnorm(10*5),nrow=10)
x = rnorm(5)
b = A\%*\%x

out = lsolve.gs(A,b)
matout = cbind(matrix(x),out$x); colnames(matout) = c("true x","est from GS")
print(matout)

}
\references{
\insertRef{demmel_applied_1997}{Rlinsolve}
}
