% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphFunctions.R
\name{lolli_plot}
\alias{lolli_plot}
\title{Create a Timeline of Selected Event Metrics.}
\usage{
lolli_plot(data, metric = "int_max", event_count = 3,
  xaxis = "date_start")
}
\arguments{
\item{data}{Output from the \code{\link{detect}} function.}

\item{metric}{One of \code{int_mean}, \code{int_max}, \code{int_cum} and \code{duration}.
Default is \code{int_cum}.}

\item{event_count}{The number of top events to highlight. Default is 3.}

\item{xaxis}{One of \code{event_no}, \code{date_start} or \code{date_peak}.
Default is \code{date_start}.}
}
\value{
The function will return a graph of the intensity of the selected
metric along the y-axis versus either \code{date} or \code{event_no}.
The number of top events as per \code{event_count} will be highlighted
in a brighter colour.
}
\description{
Visualise a timeline of several event metrics as 'lollipop' graphs.
}
\examples{
t_dat <- make_whole(sst_NW_Atl)
res <- detect(t_dat, climatology_start = 1983, climatology_end = 2012) # using default values

\dontrun{
lolli_plot(res, metric = "int_cum", event_count = 3, xaxis = "date_peak")
}
}
\author{
Albertus J. Smit and Robert W. Schlegel
}

