\name{respondentlist}
\alias{respondentlist}
\alias{print.sm_respondent}
\title{Get respondent list}
\description{Get list of respondents for a survey}
\usage{
respondentlist(survey, collector = NULL, page = NULL, page_size = NULL,
               start_date = NULL, end_date = NULL,
               start_modified_date = NULL,
               end_modified_date = NULL,
               name = NULL, order_asc = NULL, order_by = NULL,
               fields = NULL,
               api_key = getOption('sm_api_key'),
               oauth_token = getOption('sm_oauth_token'))
}
\arguments{
\item{survey}{A Survey Monkey survey ID number (or an object of class \dQuote{sm_survey} from which it can be extracted), possibly returned by \code{\link{surveylist}}.}
\item{collector}{A collector ID number, possibly returned by \code{\link{collectors}}.}
\item{page}{A number indicating which page of results to return.}
\item{page_size}{The number of results to return per API call. Default is 1000.}
\item{start_date}{A start datetime to restrict result to. Any returned respondents must have been created on or after this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{end_date}{An end datetime to restrict result to. Any returned respondents must have been created strictly before this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{start_modified_date}{A start datetime to restrict result to. Any returned respondents must have been modified on or after this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{end_modified_date}{An end datetime to restrict result to. Any returned respondents must have been modified strictly before this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{name}{A character string containing a name of a survey collector to search for.}
\item{order_asc}{A boolean indicating whether results should be sorted in ascending or descending (the default) order.}
\item{order_by}{A boolean indicating whether results should be sorted in ascending or descending (the default) order.}
\item{fields}{A character vector containing the names of fields to return in each \code{sm_collector} class object. See Details.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
%  \item{...}{Other arguments. Currently ignored.}
}
\details{Retrieves list of respondents to a specified survey or, more specifically, a survey collector. BASIC users can only retrieve the first 100 respondents. Surveys with over 500,000 respondents will not be returned.

The \code{fields} argument accepts one or more of the following values: \code{date_start}, \code{date_modified}, \code{collector_id}, \code{collection_mode}, \code{custom_id}, \code{email}, \code{first_name}, \code{last_name}, \code{ip_address}, \code{status}, \code{analysis_url}.
}
\value{A list containing one or more objects of class \code{sm_respondent}.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_respondent_list}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
s <- surveylist()
respondentlist(s[[1]]$survey_id)
}
}
%\keyword{}
