\name{templates}
\alias{templates}
\title{Get Survey Templates}
\description{Get the list of available survey templates}
\usage{
templates(page = NULL, page_size = NULL,
          language_id = NULL, category_id = NULL,
          only_mine = TRUE, fields = NULL,
          api_key = getOption('sm_api_key'),
          oauth_token = getOption('sm_oauth_token'), ...)
}
\arguments{
\item{page}{A number indicating which page of results to return.}
\item{page_size}{The number of results to return per API call.}
\item{language_id}{Language Id to filter templates with. See \href{https://developer.surveymonkey.com/mashery/data_types}{Data types} for more information.}
\item{category_id}{Category Id to filter templates with.}
\item{only_mine}{A boolean specifying whether to return only templates available to the user. Default is \code{TRUE}.}
\item{fields}{A character vector containing the names of fields to return in each \code{sm_collector} class object. See Details.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
\item{...}{Other arguments passed to \code{\link[httr]{POST}}.}
}
\details{Retrieves the list of templates available to the user. These can then be used in \code{\link{createsurvey}} to generate a new survey.

The \code{fields} argument accepts one or more of the following values: \code{language_id}, \code{title}, \code{short_description}, \code{long_description}, \code{is_available_to_current_user}, \code{is_featured}, \code{is_certified}, \code{page_count}, \code{question_count}, \code{preview_url}, \code{category_id}, \code{category_name}, \code{category_description}, \code{date_modified}, \code{date_created}.}
\value{A list of objects of class \code{sm_template}.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_template_list}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
templates()
}
}
%\keyword{}
