% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-plot.R
\docType{methods}
\name{plot,rnetBasic-method}
\alias{plot,rnetBasic-method}
\alias{plot}
\title{Plot methods for R-nets}
\usage{
\S4method{plot}{rnetBasic}(x, draw_plot = TRUE, ...)
}
\arguments{
\item{x}{an rnet object of class 'rnetBasic'}

\item{draw_plot}{logial. Will produce plot if TRUE. Only returns function call when FALSE.}

\item{...}{additional arguments passed to plot.igraph(). Currently, partial matches are not allowed.}
}
\value{
A character string containing the function call to plot the graph (used inside the function generate plot).
}
\description{
A plot method for R-nets, and incorporates vertex and edge metadata and layout, if assigns. Only vertex and edge metadata with names that match igraph decoration options (without 'vertex.' or 'edge.' appended to the attribute name; see plot.igraph). layout is pulled from 'layout_master' in the rnet object, if it exists. The layout frame can contain 3 columns, with the first column used to match the coordinates in the next two columns to graph vertices OR can contain 2 columns with the same number of vertices in the graph.
}
\details{
Extends generic plot() to rnetBasic objects to avoid needing to use plot.igraph(rnetbasic.obj@R). igraph plotting arguments (see ?igraph.plotting) can still be declared and will override the attributes used by default in V(x@R) and E(x@r). Other standard arguments from plot.igraph() are also used.\cr The plot can be drawn automatically, or just the function call to draw the plot later using eval(parse(text = 'plot.call.string')).
}
\examples{

#Create Rnet object
R_EC_08 <- Rnet(x = NARMS_EC_DATA,
  L1 = 0.15,
  vertices = c('AMP', 'AMC','FOX', 'TIO', 'AXO', 'CIP', 'NAL', 'TET', 'COT', 'FIS'),
  subset = expression(Year == 2008)
  )

#Plot the network without decoration
plot(R_EC_08)

#View the function call and use it to plot the network with plot.igraph() 
plot_call <- plot(R_EC_08, draw_plot = FALSE)
plot_call
eval(parse(text = plot_call))

#Decorate the graph using igraph plotting arguments
plot_call_decorated <- plot(R_EC_08, vertex.shape = 'square', vertex.color = 'cyan', edge.width = 3)
plot_call_decorated

#Decorate the graph using Assign_Vmetadata() and Assign_Emetadata()
Assign_Emetadata(R_EC_08, E_ATTRS, 'omega', e_cuts = c(0, 0.05, 0.10, 0.20, 1))
Assign_Vmetadata(R_EC_08, V_ATTRS, 'Code')

plot_call_metadata <- plot(R_EC_08, vertex.frame.color = NA)
plot_call_metadata

#Override a previously assigned graphical attribute (vertex.color)
plot_call_metadata <- plot(R_EC_08, vertex.frame.color = NA, vertex.color = c('red', 'green'))
plot_call_metadata
}
