% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{saveCtryNlData}
\alias{saveCtryNlData}
\title{Save a data frame of a country's data to the appropriate location}
\usage{
saveCtryNlData(ctryNlDataDF, ctryCode = NULL, admLevel,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL)
}
\arguments{
\item{ctryNlDataDF}{dataframe with the country data to save}

\item{ctryCode}{the ctryCode to which the data belongs}

\item{admLevel}{the country admin level to process}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
None
}
\description{
Saves the data frame created from processNlCountry* to the appropriate location. 
    Note: This function does not perform any validation error checking and will overwrite 
    existing data. Use with caution.
}
\examples{

\dontrun{
Rnightlights:::saveCtryNlData(ctryNlDataDF, ctryCode)
}

}
