% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnmrTools.R
\name{plotSpecMat}
\alias{plotSpecMat}
\title{plotSpecMat Overlaid/Stacked Plot}
\usage{
plotSpecMat(specMat, ppm_lim = c(min(specMat$ppm), max(specMat$ppm)),
  K = 0.67, pY = 1, dppm_max = 0.2 * (max(ppm_lim) - min(ppm_lim)),
  asym = 1, beta = 0, cols = NULL)
}
\arguments{
\item{specMat}{a 'specMat' object - Spectra matrix in specMat$int (rows = samples, 
columns = buckets)}

\item{ppm_lim}{ppm range of the plot}

\item{K}{Graphical height of the stack (0 .. 1),(default=0.67)}

\item{pY}{Intensity limit factor (default 1)}

\item{dppm_max}{Max ppm shift to have a perspective effect}

\item{asym}{Correction of vertical parallax effect  (-1 .. 1)
-1 : parallelogram
 0 : trapeze with maximum asymmetric
 1 : symmetric trapeze}

\item{beta}{Correction of horizontal parallax effect   (0 .. 0.2) (defaut 0)}

\item{cols}{Vector of colors (same size that the number of spectra, i.e dim(specmat)[1])}
}
\description{
\code{plotSpecMat} Plot spectra set, overlaid or stacked; if stacked, plot with or 
without a perspective effect.
}
\examples{
 \donttest{
  data_dir <- system.file("extra", package = "Rnmr1D")
  cmdfile <- file.path(data_dir, "NP_macro_cmd.txt")
  samplefile <- file.path(data_dir, "Samples.txt")
  out <- Rnmr1D::doProcessing(data_dir, cmdfile=cmdfile, 
                                samplefile=samplefile, ncpu=detectCores())
  # Overlaid plot
  plotSpecMat(out$specMat, ppm_lim=c(0.5,9), K=0, pY=0.1)
  # Stacked plot with perspective effect
  plotSpecMat(out$specMat, ppm_lim=c(-0.1,9),K=0.33)
  # Stacked plot with perspective effect with maximum asymmetric
  plotSpecMat(out$specMat, ppm_lim=c(0.5,5), K=0.33, asym=0)
  cols <- c(rep("red",3), rep("blue",3))
  # Stacked plot with colors accordings to group levels
  plotSpecMat(out$specMat, ppm_lim=c(0.5,5), K=0.67, dppm_max=0, cols=cols)
}
}
