% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTools.R
\name{plotLoadings}
\alias{plotLoadings}
\title{plotLoadings}
\usage{
plotLoadings(
  data,
  pc1,
  pc2,
  associations = NULL,
  main = "Loadings",
  xlimu = c(min(data[, pc1]), max(data[, pc1])),
  ylimu = c(min(data[, pc2]), max(data[, pc2])),
  cexlabel = 1,
  pch = 20,
  ellipse = TRUE,
  level = 0.8
)
}
\arguments{
\item{data}{the matrix of variable loadings coming from a multivariable analysis, typically a Principal Component Analysis (PCA)}

\item{pc1}{the fist component of the matrix of variable loadings to be plotted.}

\item{pc2}{the second component of the matrix of variable loadings to be plotted.}

\item{associations}{the associations matrix that gives for each cluster (column 2) the corresponding buckets (column 1)}

\item{main}{Change the default plot title on the rigth corner}

\item{xlimu}{gives the limit to be plotted of the first component}

\item{ylimu}{gives the limit to be plotted of the second component}

\item{cexlabel}{number indicating the amount by which plotting text and symbols should be scaled relative to the default.}

\item{pch}{Plotting Symbols}

\item{ellipse}{boolean - specifies if ellipses are plot or not for each cluster}

\item{level}{confidence level for plotting the ellipses}
}
\description{
Plots the two components defined by pc1, pc2 of the matrix of variable loadings coming from a 
multivariable analysis, typically a Principal Component Analysis (PCA).
It can also plot the ellipses corresponding to each cluster defined by the associations matrix 
if not null. (in fact it is the main interest of this function).
}
